/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.is.repositories;

import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Required;

public class FindExistingRepositoriesJobNode
extends AbstractJobNode {
    private ServiceLocator<ISLookUpService> lookupLocator;

    public void execute(Engine engine, NodeToken token) {
        try {
            String xquery = "for $x in /*[.//RESOURCE_TYPE/@value='RepositoryServiceResourceType'] return concat ($x//RESOURCE_IDENTIFIER/@value, '@@@', $x//RESOURCE_KIND/@value, '@@@', $x//EXTRA_FIELDS/FIELD[./key='OpenAireDataSourceId']/value)";
            List list = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(xquery);
            HashMap map = Maps.newHashMap();
            for (String s : list) {
                String[] arr = s.split("@@@");
                if (arr.length != 3) continue;
                map.put(arr[2], new RepositoryInfo(arr[1], arr[0]));
            }
            token.getEnv().setTransientAttribute("existingRepos", (Object)map);
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (Exception e) {
            this.failed(engine, token, e);
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    class RepositoryInfo {
        public String resourceKind;
        public String repoId;

        public RepositoryInfo(String resourceKind, String repoId) {
            this.resourceKind = resourceKind;
            this.repoId = repoId;
        }

        public String toString() {
            return "[" + this.resourceKind + ", " + this.repoId + "]";
        }
    }
}

