/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.is.repositories;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class FindComplianceRepositoriesJobNode
extends AbstractJobNode {
    private ServiceLocator<DatabaseService> dbServiceLocator;
    private String dbName;
    private XSLTMappedResultSetFactory mappedResultSetFactory;
    private Resource xslt;
    private Resource query;
    private static final Log log = LogFactory.getLog(FindComplianceRepositoriesJobNode.class);

    public void execute(Engine engine, NodeToken token) {
        log.info((Object)"Updating repositories from DB to IS");
        try {
            StringWriter sw = new StringWriter();
            IOUtils.copy((InputStream)this.getQuery().getInputStream(), (Writer)sw);
            W3CEndpointReference epr = ((DatabaseService)this.dbServiceLocator.getService()).searchSQL(this.dbName, sw.toString());
            W3CEndpointReference mapped = this.mappedResultSetFactory.createMappedResultSet(epr, this.xslt);
            token.getEnv().setTransientAttribute("reposEPR", (Object)mapped);
            token.getEnv().setAttribute("reposEPRasString", mapped.toString());
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (Exception e) {
            this.failed(engine, token, e);
        }
    }

    public ServiceLocator<DatabaseService> getDbServiceLocator() {
        return this.dbServiceLocator;
    }

    @Required
    public void setDbServiceLocator(ServiceLocator<DatabaseService> dbServiceLocator) {
        this.dbServiceLocator = dbServiceLocator;
    }

    public String getDbName() {
        return this.dbName;
    }

    @Required
    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public Resource getQuery() {
        return this.query;
    }

    @Required
    public void setQuery(Resource query) {
        this.query = query;
    }

    public XSLTMappedResultSetFactory getMappedResultSetFactory() {
        return this.mappedResultSetFactory;
    }

    @Required
    public void setMappedResultSetFactory(XSLTMappedResultSetFactory mappedResultSetFactory) {
        this.mappedResultSetFactory = mappedResultSetFactory;
    }

    public Resource getXslt() {
        return this.xslt;
    }

    @Required
    public void setXslt(Resource xslt) {
        this.xslt = xslt;
    }
}

