/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.hbase;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.data.transform.Column;
import eu.dnetlib.data.transform.Row;
import eu.dnetlib.data.transform.XsltRowTransformer;
import eu.dnetlib.data.transform.XsltRowTransformerFactory;
import eu.dnetlib.enabling.resultset.WorkflowCountingResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.workflow.AsyncJobNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class StoreHBaseRecords
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(StoreHBaseRecords.class);
    private DataSourceResolver dataSourceResolver;
    private ResultSetClientFactory resultSetClientFactory;
    private Resource xslt;
    private XsltRowTransformerFactory xsltRowTransformerFactory;
    private WorkflowCountingResultSetFactory countingRSFactory;
    private int batchSize;

    protected void executeAsync(Engine engine, NodeToken token) {
        String dataSource = token.getEnv().getAttribute("dataSource");
        String tableName = token.getEnv().getAttribute("hbaseTable");
        Configuration conf = (Configuration)token.getEnv().getTransientAttribute("hbaseConf");
        try {
            W3CEndpointReference epr = this.getDataSourceResolver().resolve(dataSource).retrieve();
            this.doWrite(this.getCountingRSFactory().createCountingResultSet(epr, token), this.getXsltRowTransformerFactory().getTransformer(this.xsltString()), tableName, conf);
            log.info((Object)"finished import to HBase");
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (Throwable e) {
            log.error((Object)"error: ", e);
            this.failed(engine, token, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(W3CEndpointReference epr, XsltRowTransformer transformer, String tableName, Configuration conf) throws IOException {
        HTable table = new HTable(conf, tableName);
        table.setAutoFlush(false, true);
        ArrayList buffer = Lists.newArrayList();
        int i = 0;
        try {
            for (Row row : Iterables.concat((Iterable)Iterables.transform((Iterable)this.getResultSetClientFactory().getClient(epr), (Function)transformer))) {
                log.debug((Object)row);
                Put put = new Put(Bytes.toBytes((String)row.getKey()));
                for (Column col : row) {
                    put.add(Bytes.toBytes((String)row.getColumnFamily()), Bytes.toBytes((String)((String)col.getName())), (byte[])col.getValue());
                }
                buffer.add(put);
                if (++i % this.getBatchSize() != 0) continue;
                table.put((List)buffer);
                buffer.clear();
            }
        }
        finally {
            if (!buffer.isEmpty()) {
                table.put((List)buffer);
            }
            table.flushCommits();
            table.close();
        }
    }

    private String xsltString() {
        if (this.getXslt() == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)this.getXslt().getInputStream(), (Writer)writer);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return writer.toString();
    }

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    @Required
    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public XsltRowTransformerFactory getXsltRowTransformerFactory() {
        return this.xsltRowTransformerFactory;
    }

    @Required
    public void setXsltRowTransformerFactory(XsltRowTransformerFactory xsltRowTransformerFactory) {
        this.xsltRowTransformerFactory = xsltRowTransformerFactory;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @Required
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public Resource getXslt() {
        return this.xslt;
    }

    public void setXslt(Resource xslt) {
        this.xslt = xslt;
    }

    public WorkflowCountingResultSetFactory getCountingRSFactory() {
        return this.countingRSFactory;
    }

    @Required
    public void setCountingRSFactory(WorkflowCountingResultSetFactory countingRSFactory) {
        this.countingRSFactory = countingRSFactory;
    }
}

