/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.hbase;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.SizedIterable;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.workflow.AbstractJobNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class PrepareMockProjetsJobNode
extends AbstractJobNode {
    private Resource xslt;
    private int numberOfMockRecords = 1000;
    private IterableResultSetFactory iterableResultSetFactory;
    private XSLTMappedResultSetFactory xsltMappedResultSetFactory;
    private Resource mocktemplate;
    private StringTemplate template;
    private List<String> subjects;
    private List<String> contractTypes;

    public void execute(Engine engine, NodeToken token) {
        try {
            W3CEndpointReference iterEpr = this.iterableResultSetFactory.createIterableResultSet((Iterable)new SizedIterable<String>(){

                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        int count = 0;

                        @Override
                        public boolean hasNext() {
                            return this.count < this.getNumberOfElements();
                        }

                        @Override
                        public String next() {
                            try {
                                return PrepareMockProjetsJobNode.this.generateMock(this.count++);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }

                        @Override
                        public void remove() {
                        }
                    };
                }

                public int getNumberOfElements() {
                    return this.getNumberOfElements();
                }
            });
            W3CEndpointReference epr = this.xsltMappedResultSetFactory.createMappedResultSet(iterEpr, this.xslt);
            token.getEnv().setAttribute("dataSource", this.toDataSource(epr));
            super.execute(engine, token);
        }
        catch (Throwable e) {
            this.failed(engine, token, e);
        }
    }

    private String generateMock(int i) throws IOException {
        if (this.template == null) {
            StringWriter sw = new StringWriter();
            IOUtils.copy((InputStream)this.mocktemplate.getInputStream(), (Writer)sw);
            this.template = new StringTemplate(sw.toString());
        } else {
            this.template.reset();
        }
        this.template.setAttribute("pos", i);
        this.template.setAttribute("subjects", (Object)this.randomElement(this.subjects));
        this.template.setAttribute("contractType", (Object)this.randomElement(this.contractTypes));
        return this.template.toString();
    }

    private String toDataSource(W3CEndpointReference epr) throws URIException {
        return "dnet://EPR/" + URIUtil.encodePath((String)epr.toString());
    }

    private <T> T randomElement(List<T> list) {
        return list.get(RandomUtils.nextInt((int)list.size()));
    }

    public Resource getXslt() {
        return this.xslt;
    }

    @Required
    public void setXslt(Resource xslt) {
        this.xslt = xslt;
    }

    public int getNumberOfMockRecords() {
        return this.numberOfMockRecords;
    }

    @Required
    public void setNumberOfMockRecords(int numberOfMockRecords) {
        this.numberOfMockRecords = numberOfMockRecords;
    }

    public IterableResultSetFactory getIterableResultSetFactory() {
        return this.iterableResultSetFactory;
    }

    @Required
    public void setIterableResultSetFactory(IterableResultSetFactory iterableResultSetFactory) {
        this.iterableResultSetFactory = iterableResultSetFactory;
    }

    public XSLTMappedResultSetFactory getXsltMappedResultSetFactory() {
        return this.xsltMappedResultSetFactory;
    }

    @Required
    public void setXsltMappedResultSetFactory(XSLTMappedResultSetFactory xsltMappedResultSetFactory) {
        this.xsltMappedResultSetFactory = xsltMappedResultSetFactory;
    }

    public Resource getMocktemplate() {
        return this.mocktemplate;
    }

    @Required
    public void setMocktemplate(Resource mocktemplate) {
        this.mocktemplate = mocktemplate;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    @Required
    public void setSubjects(List<String> subjects) {
        this.subjects = subjects;
    }

    public List<String> getContractTypes() {
        return this.contractTypes;
    }

    @Required
    public void setContractTypes(List<String> contractTypes) {
        this.contractTypes = contractTypes;
    }
}

