/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.db.feed;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.workflow.BlackboardJobNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class StoreDBRecords
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(StoreDBRecords.class);
    private ServiceLocator<ISLookUpService> lookupLocator;
    private DataSourceResolver dataSourceResolver;
    private String databaseName;
    private Resource xslt;

    protected String locateService(NodeToken token) {
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'DatabaseServiceResourceType']//RESOURCE_IDENTIFIER/@value/string()";
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'DatabaseServiceResourceType']//RESOURCE_IDENTIFIER/@value/string()");
        }
        catch (ISLookUpException e) {
            return null;
        }
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) {
        super.prepareJob(job, token);
        try {
            Map params = (Map)token.getEnv().getTransientAttribute("xsltParams");
            String dataSource = token.getFullEnv().getAttribute("dataSource");
            job.setAction("IMPORT");
            job.getParameters().put("db", this.databaseName);
            job.getParameters().put("epr", this.obtainEPR(dataSource, true));
            job.getParameters().put("xslt", this.obtainXslt(true));
            job.getParameters().put("xsltParams", this.base64(this.toJSon(params)));
        }
        catch (Exception e) {
            log.error((Object)"Job preparation FAILED", (Throwable)e);
            throw new RuntimeException("Job preparation FAILED", e);
        }
    }

    private String base64(String s) {
        return new String(Base64.encodeBase64((byte[])s.getBytes()));
    }

    private String toJSon(Map<String, String> map) {
        return new Gson().toJson(map, new TypeToken<Map<String, String>>(){}.getType());
    }

    private String obtainEPR(String dataSource, boolean base64) throws Exception {
        W3CEndpointReference epr = this.dataSourceResolver.resolve(dataSource).retrieve();
        String res = epr.toString();
        if (base64) {
            return new String(Base64.encodeBase64((byte[])res.getBytes()));
        }
        return res;
    }

    private String obtainXslt(boolean base64) throws IOException {
        StringWriter xsltBuffer = new StringWriter();
        IOUtils.copy((InputStream)this.xslt.getInputStream(), (Writer)xsltBuffer);
        String res = xsltBuffer.toString();
        if (base64) {
            return new String(Base64.encodeBase64((byte[])res.getBytes()));
        }
        return res;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Required
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public Resource getXslt() {
        return this.xslt;
    }

    @Required
    public void setXslt(Resource xslt) {
        this.xslt = xslt;
    }

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    @Required
    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

