/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.db.feed;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class SqlUpdateJobNode
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(SqlUpdateJobNode.class);
    private ServiceLocator<DatabaseService> dbServiceLocator;
    private String databaseName;
    private String sql;

    public void execute(Engine engine, NodeToken token) {
        try {
            log.info((Object)("performing SQL: " + this.getSql()));
            if (!((DatabaseService)this.getDbServiceLocator().getService()).updateSQL(this.getDatabaseName(), this.getSql())) {
                throw new Exception("unable to update database");
            }
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (Exception e) {
            this.failed(engine, token, e);
        }
    }

    public ServiceLocator<DatabaseService> getDbServiceLocator() {
        return this.dbServiceLocator;
    }

    @Required
    public void setDbServiceLocator(ServiceLocator<DatabaseService> dbServiceLocator) {
        this.dbServiceLocator = dbServiceLocator;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Required
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getSql() {
        return this.sql;
    }

    @Required
    public void setSql(String sql) {
        this.sql = sql;
    }
}

