/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.db.feed;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class RepositoryResolver
implements UnaryFunction<String, String> {
    private static final Log log = LogFactory.getLog(RepositoryResolver.class);
    private ResultSetClientFactory resultSetClientFactory;
    private ServiceLocator<DatabaseService> dbServiceLocator;
    private String databaseName;
    private String collectedDatasourceIdXpath;
    private String hostingDatasoureIdXpath;
    private Map<String, String> idCache = Maps.newHashMap();
    private SAXReader reader = new SAXReader();

    public String evaluate(String record) {
        try {
            Document doc = this.reader.read((Reader)new StringReader(record));
            String collectDsId = doc.valueOf(this.getCollectedDatasourceIdXpath());
            String hostingDsId = doc.valueOf(this.getHostingDatasoureIdXpath());
            if (collectDsId.equals(hostingDsId)) {
                return record;
            }
            if (!this.idCache.containsKey(hostingDsId)) {
                IterableResultSetClient rsClient = this.resultSetClientFactory.getClient(((DatabaseService)this.dbServiceLocator.getService()).searchSQL(this.getDatabaseName(), "SELECT datasourceid FROM datasources WHERE access_info_package = '" + hostingDsId + "'"));
                Document res = this.reader.read((Reader)new StringReader((String)Iterables.getOnlyElement((Iterable)rsClient)));
                this.idCache.put(hostingDsId, res.valueOf("//FIELD[./@name = 'datasourceid'"));
                log.info((Object)("resolving url: " + hostingDsId + " to id: " + this.idCache.get(hostingDsId)));
            }
            doc.selectSingleNode(this.getHostingDatasoureIdXpath()).setText(this.idCache.get(hostingDsId));
            String asXML = doc.asXML();
            return asXML;
        }
        catch (DocumentException e) {
            log.warn((Object)"unable to parse record", (Throwable)e);
            return record;
        }
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public ServiceLocator<DatabaseService> getDbServiceLocator() {
        return this.dbServiceLocator;
    }

    @Required
    public void setDbServiceLocator(ServiceLocator<DatabaseService> dbServiceLocator) {
        this.dbServiceLocator = dbServiceLocator;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Required
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCollectedDatasourceIdXpath() {
        return this.collectedDatasourceIdXpath;
    }

    @Required
    public void setCollectedDatasourceIdXpath(String collectedDatasourceIdXpath) {
        this.collectedDatasourceIdXpath = collectedDatasourceIdXpath;
    }

    public String getHostingDatasoureIdXpath() {
        return this.hostingDatasoureIdXpath;
    }

    @Required
    public void setHostingDatasoureIdXpath(String hostingDatasoureIdXpath) {
        this.hostingDatasoureIdXpath = hostingDatasoureIdXpath;
    }
}

