/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.db.feed;

import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.Reader;
import java.io.StringReader;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.BaseElement;
import org.springframework.beans.factory.annotation.Required;

public class RecordFilter
implements UnaryFunction<String, String> {
    private static final Log log = LogFactory.getLog(RecordFilter.class);
    private ServiceLocator<DatabaseService> dbServiceLocator;
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String databaseName;
    private String collectedDatasourceIdXpath;
    private String hostingDatasoureIdXpath;
    private SAXReader reader = new SAXReader();
    private Set<String> collectDsIdCache = Sets.newHashSet();
    private Set<String> hostingDsIdCache = Sets.newHashSet();
    private Set<String> repositoryIdCache = Sets.newHashSet();

    public String evaluate(String record) {
        String emptyDoc = this.getEmptyDocument();
        try {
            Document doc = this.reader.read((Reader)new StringReader(record));
            String collectDsId = doc.valueOf(this.getCollectedDatasourceIdXpath());
            String hostingDsId = doc.valueOf(this.getHostingDatasoureIdXpath());
            if (collectDsId == null || collectDsId.isEmpty()) {
                return emptyDoc;
            }
            if (hostingDsId == null || hostingDsId.isEmpty()) {
                return emptyDoc;
            }
            if (Objects.equal((Object)collectDsId, (Object)hostingDsId)) {
                if (this.checkDbCache(this.collectDsIdCache, "datasourceid", collectDsId)) {
                    return record;
                }
                return emptyDoc;
            }
            if (!this.checkDbCache(this.hostingDsIdCache, "access_info_package", hostingDsId)) {
                return emptyDoc;
            }
            if (!this.checkIsCache(this.repositoryIdCache, collectDsId)) {
                return emptyDoc;
            }
            return record;
        }
        catch (DocumentException e) {
            log.error((Object)("unable to parse document: \n" + record), (Throwable)e);
            return emptyDoc;
        }
    }

    private String getEmptyDocument() {
        DOMDocument emptyDoc = new DOMDocument();
        emptyDoc.setRootElement((Element)new BaseElement("record"));
        return emptyDoc.asXML();
    }

    private boolean checkIsCache(Set<String> cache, String value) {
        if (!cache.contains(value)) {
            String xquery = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + value + "' or " + ".//DATASOURCE_ORIGINAL_ID/text() = '" + value + "' or " + ".//FIELD[./key = 'OpenAireDataSourceId' and ./value = '" + value + "']]" + "//RESOURCE_IDENTIFIER/@value/string()";
            log.info((Object)("searching for profile id: " + xquery));
            try {
                if (!((String)Iterables.getOnlyElement((Iterable)((ISLookUpService)this.getLookupLocator().getService()).quickSearchProfile(xquery))).isEmpty()) {
                    cache.add(value);
                }
            }
            catch (NoSuchElementException e) {
                return false;
            }
            catch (ISLookUpException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return cache.contains(value);
    }

    private boolean checkDbCache(Set<String> cache, String colName, String value) {
        boolean b;
        String table = "datasources";
        if (!cache.contains(value) && ((DatabaseService)this.getDbServiceLocator().getService()).contains(this.databaseName, table, colName, value)) {
            cache.add(value);
        }
        if (!(b = cache.contains(value))) {
            log.warn((Object)("couldn't find " + value + " in table: " + table + ", column:" + colName));
        }
        return b;
    }

    public ServiceLocator<DatabaseService> getDbServiceLocator() {
        return this.dbServiceLocator;
    }

    @Required
    public void setDbServiceLocator(ServiceLocator<DatabaseService> dbServiceLocator) {
        this.dbServiceLocator = dbServiceLocator;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Required
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCollectedDatasourceIdXpath() {
        return this.collectedDatasourceIdXpath;
    }

    @Required
    public void setCollectedDatasourceIdXpath(String collectedDatasourceIdXpath) {
        this.collectedDatasourceIdXpath = collectedDatasourceIdXpath;
    }

    public String getHostingDatasoureIdXpath() {
        return this.hostingDatasoureIdXpath;
    }

    @Required
    public void setHostingDatasoureIdXpath(String hostingDatasoureIdXpath) {
        this.hostingDatasoureIdXpath = hostingDatasoureIdXpath;
    }
}

