/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.db.feed;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.tools.SourceSinkResolver;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import javax.annotation.Resource;

public class FindRepositoryFromMDStoreJob
extends AbstractJobNode {
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource
    private SourceSinkResolver sourceSinkResolver;

    public void execute(Engine engine, NodeToken token) {
        String mdId = this.findMdId(token);
        String query = "//RESOURCE_PROFILE[.//MDSTORE_DS_IDENTIFIER='" + mdId + "' or contains(.//DATA_SINK, '" + mdId + "')]//REPOSITORY_SERVICE_IDENTIFIER/text()";
        try {
            String repId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
            token.getEnv().setAttribute("repositoryId", repId);
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (ISLookUpException e) {
            this.failed(engine, token, e);
        }
    }

    private String findMdId(NodeToken token) {
        String mdId = token.getFullEnv().getAttribute("mdId");
        if (mdId != null) {
            return mdId;
        }
        String descriptor = token.getFullEnv().getAttribute("dataSource");
        return this.sourceSinkResolver.getSourceMdId(descriptor);
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

