/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.db.feed;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.miscutils.iterators.xml.IterableXmlParser;
import eu.dnetlib.workflow.AbstractJobNode;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.net.URL;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.springframework.beans.factory.annotation.Required;

public class FetchHttpEntities
extends AbstractJobNode {
    private IterableResultSetFactory iterableResultSetFactory;
    private String element;

    public void execute(Engine engine, NodeToken token) {
        try {
            URL url = new URL(token.getEnv().getAttribute("accessInfoPackage"));
            BufferedInputStream bis = null;
            switch (Protocols.valueOf(url.getProtocol())) {
                case classpath: {
                    bis = new BufferedInputStream(((Object)((Object)this)).getClass().getResourceAsStream(url.getPath()));
                    break;
                }
                case file: {
                    bis = new BufferedInputStream(new FileInputStream(url.getPath()));
                    break;
                }
                case http: {
                    HttpClient client = new HttpClient();
                    GetMethod method = new GetMethod(url.toString());
                    int responseCode = client.executeMethod((HttpMethod)method);
                    if (200 != responseCode) {
                        throw new HttpException("got http status " + responseCode + " while getting opendoar repositories from url: " + url);
                    }
                    bis = new BufferedInputStream(method.getResponseBodyAsStream());
                    break;
                }
            }
            W3CEndpointReference epr = this.getIterableResultSetFactory().createIterableResultSet((Iterable)new IterableXmlParser(this.getElement(), bis));
            token.getEnv().setAttribute("dataSource", "dnet://EPR/" + URIUtil.encodePath((String)epr.toString()));
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (Exception e) {
            this.failed(engine, token, e);
        }
    }

    public String getElement() {
        return this.element;
    }

    @Required
    public void setElement(String element) {
        this.element = element;
    }

    public IterableResultSetFactory getIterableResultSetFactory() {
        return this.iterableResultSetFactory;
    }

    @Required
    public void setIterableResultSetFactory(IterableResultSetFactory iterableResultSetFactory) {
        this.iterableResultSetFactory = iterableResultSetFactory;
    }

    private static enum Protocols {
        http,
        file,
        classpath;

    }
}

