/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.db.feed;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class FeedHelper {
    private static final Log log = LogFactory.getLog(FeedHelper.class);
    private static FeedHelper instance;
    private Map<String, String> doarIds = new HashMap<String, String>();
    private ServiceLocator<ISLookUpService> lookupLocator;

    public FeedHelper() {
        instance = this;
    }

    public String getDoarId(String repoId) throws ISLookUpDocumentNotFoundException, ISLookUpException {
        if (!this.doarIds.containsKey(repoId)) {
            this.doarIds.put(repoId, this.doarIdFromProfile(repoId));
        }
        return this.doarIds.get(repoId);
    }

    private String doarIdFromProfile(String repoId) throws ISLookUpDocumentNotFoundException, ISLookUpException {
        log.info((Object)("fetching opendoar id from IS " + repoId));
        String query = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + repoId + "']//FIELD[key='OpenAireDataSourceId']/value/string()";
        return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
    }

    public static String getOpenDoarId(String repoId) throws ISLookUpDocumentNotFoundException, ISLookUpException {
        return instance.getDoarId(repoId);
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

