/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.db.feed;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.workflow.BlackboardJobNode;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ClearOldDBRecords
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(ClearOldDBRecords.class);
    private ServiceLocator<ISLookUpService> lookupLocator;
    private StringTemplate clearOldSqlTemplate;
    private String databaseName;

    protected String locateService(NodeToken token) {
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'DatabaseServiceResourceType']//RESOURCE_IDENTIFIER/@value/string()";
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'DatabaseServiceResourceType']//RESOURCE_IDENTIFIER/@value/string()");
        }
        catch (ISLookUpException e) {
            return null;
        }
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) {
        super.prepareJob(job, token);
        try {
            String repositoryId = token.getEnv().getAttribute("repositoryId");
            String xquery = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + repositoryId + "']//FIELD " + "return $x[./key = 'OpenAireDataSourceId']/value/text()";
            log.debug((Object)("cleaning old results for datasource: \n" + xquery));
            String dataSourceId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(xquery);
            job.setAction("EXEC");
            job.getParameters().put("db", this.databaseName);
            job.getParameters().put("sql", this.getSQL(dataSourceId));
        }
        catch (Exception e) {
            log.error((Object)"Job preparation FAILED", (Throwable)e);
            throw new RuntimeException("Job preparation FAILED", e);
        }
    }

    private String getSQL(String dataSourceId) {
        StringTemplate sqlTemplate = new StringTemplate(this.getClearOldSqlTemplate().getTemplate());
        sqlTemplate.setAttribute("datasourceid", (Object)dataSourceId);
        String sql = sqlTemplate.toString();
        log.debug((Object)("cleaning old results with SQL:\n" + sql));
        return sql;
    }

    public StringTemplate getClearOldSqlTemplate() {
        return this.clearOldSqlTemplate;
    }

    @Required
    public void setClearOldSqlTemplate(StringTemplate clearOldSqlTemplate) {
        this.clearOldSqlTemplate = clearOldSqlTemplate;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Required
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

