/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.db;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AsyncJobNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class QueryDatabaseJob
extends AsyncJobNode {
    private ServiceLocator<DatabaseService> dbServiceLocator;
    private String dbName;
    private Resource query;
    private Resource xslt;

    public void executeAsync(Engine engine, NodeToken token) {
        try {
            String query = this.getString(this.query);
            W3CEndpointReference epr = null;
            epr = this.getXslt() != null ? ((DatabaseService)this.getDbServiceLocator().getService()).xsltSearchSQL(this.getDbName(), query, this.getString(this.getXslt())) : ((DatabaseService)this.getDbServiceLocator().getService()).searchSQL(this.getDbName(), query);
            token.getEnv().setAttribute("dataSource", this.toDataSource(epr));
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (Throwable e) {
            this.failed(engine, token, e);
        }
    }

    private String getString(Resource r) throws IOException {
        StringWriter sw = new StringWriter();
        InputStream is = r.getInputStream();
        IOUtils.copy((InputStream)is, (Writer)sw);
        IOUtils.closeQuietly((InputStream)is);
        return sw.toString();
    }

    private String toDataSource(W3CEndpointReference epr) throws URIException {
        return "dnet://EPR/" + URIUtil.encodePath((String)epr.toString());
    }

    public String getDbName() {
        return this.dbName;
    }

    @Required
    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public ServiceLocator<DatabaseService> getDbServiceLocator() {
        return this.dbServiceLocator;
    }

    @Required
    public void setDbServiceLocator(ServiceLocator<DatabaseService> dbServiceLocator) {
        this.dbServiceLocator = dbServiceLocator;
    }

    public Resource getQuery() {
        return this.query;
    }

    @Required
    public void setQuery(Resource query) {
        this.query = query;
    }

    public Resource getXslt() {
        return this.xslt;
    }

    public void setXslt(Resource xslt) {
        this.xslt = xslt;
    }
}

