/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.db;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.workflow.AbstractJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class PrepareParameters
extends AbstractJobNode {
    private DataSourceResolver dataSourceResolver;
    private ResultSetClientFactory resultSetClientFactory;

    public void execute(Engine engine, NodeToken token) {
        String dataSource = token.getEnv().getAttribute("dataSource");
        HashMap params = Maps.newHashMap();
        try {
            W3CEndpointReference epr = this.getDataSourceResolver().resolve(dataSource).retrieve();
            SAXReader reader = new SAXReader();
            String xml = (String)Iterables.getOnlyElement((Iterable)this.getResultSetClientFactory().getClient(epr));
            Document doc = reader.read((Reader)new StringReader(xml));
            params.put("parentDatasourceId", doc.valueOf("//FIELD[@name = 'id']"));
            params.put("namespacePrefix", doc.valueOf("//FIELD[@name = 'namespaceprefix']"));
            token.getEnv().setAttribute("accessInfoPackage", doc.valueOf("//FIELD[@name = 'accessinfopackage']"));
            token.getEnv().setTransientAttribute("xsltParams", (Object)params);
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (Exception e) {
            this.failed(engine, token, e);
        }
    }

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    @Required
    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }
}

