/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.datacite;

import com.google.common.base.Joiner;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class FindRelationXSLTFunctions {
    private static Map<String, Set<String>> relationMap;
    private static InputStream filterFile;

    public static String getRelatedValue(String identifier) {
        if (relationMap == null) {
            relationMap = FindRelationXSLTFunctions.initializeHashMap();
        }
        if (!relationMap.containsKey(identifier)) {
            return "";
        }
        String s = Joiner.on((String)",").join((Iterable)relationMap.get(identifier));
        return s;
    }

    public static Map<String, Set<String>> initializeHashMap() {
        SAXReader reader = new SAXReader();
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        try {
            Document root = reader.read(filterFile);
            for (Object node : root.selectNodes("//record")) {
                Element e = (Element)node;
                String relatedId = e.valueOf("@relatedId");
                String nameSpacePrefix = e.valueOf("@namespacePrefix");
                String dataciteId = e.valueOf("@dataciteId");
                relatedId = nameSpacePrefix + "::" + Hashing.md5((String)relatedId);
                if (!map.containsKey(dataciteId)) {
                    map.put(dataciteId, new HashSet());
                }
                ((Set)map.get(dataciteId)).add(relatedId);
            }
            return map;
        }
        catch (DocumentException e) {
            return null;
        }
    }

    static {
        filterFile = FindRelationXSLTFunctions.class.getResourceAsStream("datacite-filter.xml");
    }
}

