/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.compliance;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class RepositoryProfileFilter
implements UnaryFunction<String, String> {
    private ServiceLocator<ISLookUpService> lookupLocator;
    private String hostingDatasoureIdXpath;
    private SAXReader reader = new SAXReader();

    public String evaluate(String record) {
        try {
            Document doc = this.reader.read((Reader)new StringReader(record));
            String datasourceId = doc.valueOf(this.getHostingDatasoureIdXpath());
            String string = !datasourceId.isEmpty() && this.missingDatasourceIS(datasourceId) ? record : "";
            return string;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private boolean missingDatasourceIS(String datasourceId) throws ISLookUpException {
        String xquery = "//RESOURCE_PROFILE[.//RESOURCE_KIND/@value='RepositoryServiceResources' and .//FIELD[./key='OpenAireDataSourceId' and ./value='" + datasourceId + "']]";
        List res = ((ISLookUpService)this.getLookupLocator().getService()).quickSearchProfile(xquery);
        return res.isEmpty();
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public String getHostingDatasoureIdXpath() {
        return this.hostingDatasoureIdXpath;
    }

    @Required
    public void setHostingDatasoureIdXpath(String hostingDatasoureIdXpath) {
        this.hostingDatasoureIdXpath = hostingDatasoureIdXpath;
    }
}

