/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.compliance;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.DataSinkSourceException;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class PrepareDatasourceProfiles
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(PrepareDatasourceProfiles.class);
    private ServiceLocator<DatabaseService> dbServiceLocator;
    private DataSourceResolver dataSourceResolver;
    private String databaseName;
    private ResultSetClientFactory resultSetClientFactory;
    private String hostingDatasoureIdXpath;
    private XSLTMappedResultSetFactory mappedResultSetFactory;
    private Resource xslt;
    private Function<String, String> joiner = new Function<String, String>(){

        public String apply(String s) {
            return "'" + s + "'";
        }
    };
    private Predicate<String> filter = new Predicate<String>(){

        public boolean apply(String s) {
            return !s.trim().isEmpty();
        }
    };

    public void execute(Engine engine, NodeToken token) {
        try {
            String dataSource = token.getFullEnv().getAttribute("dataSource");
            SAXReader reader = new SAXReader();
            HashSet ids = Sets.newHashSet();
            for (String record : this.getResultSetClientFactory().getClient(this.resolve(dataSource))) {
                if (record == null || record.isEmpty()) continue;
                Document doc = this.parseDocument(reader, record);
                String datasourceId = doc.valueOf(this.getHostingDatasoureIdXpath());
                ids.add(datasourceId);
            }
            Iterable filtered = Iterables.filter((Iterable)ids, this.filter);
            log.info((Object)("preparing " + Iterables.size((Iterable)filtered) + " new datasource profiles"));
            String values = Joiner.on((String)", ").join(Iterables.transform((Iterable)filtered, this.joiner));
            String sql = "SELECT * FROM datasources WHERE datasourceid = any(ARRAY[" + values + "])";
            if (values.isEmpty()) {
                engine.complete(token, "skip");
            } else {
                log.debug((Object)sql);
                W3CEndpointReference epr = this.getMappedResultSetFactory().createMappedResultSet(((DatabaseService)this.getDbServiceLocator().getService()).searchSQL(this.getDatabaseName(), sql), this.getXslt());
                token.getEnv().setAttribute("datasourceProfiles", this.toDataSource(epr));
                engine.complete(token, Arc.DEFAULT_ARC);
            }
        }
        catch (Exception e) {
            this.failed(engine, token, e);
        }
    }

    private Document parseDocument(SAXReader reader, String record) {
        try {
            return reader.read((Reader)new StringReader(record));
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    protected String toDataSource(W3CEndpointReference epr) throws URIException {
        return "dnet://EPR/" + URIUtil.encodePath((String)epr.toString());
    }

    protected W3CEndpointReference resolve(String dataSource) throws DataSinkSourceException {
        return this.getDataSourceResolver().resolve(dataSource).retrieve();
    }

    public ServiceLocator<DatabaseService> getDbServiceLocator() {
        return this.dbServiceLocator;
    }

    @Required
    public void setDbServiceLocator(ServiceLocator<DatabaseService> dbServiceLocator) {
        this.dbServiceLocator = dbServiceLocator;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Required
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public XSLTMappedResultSetFactory getMappedResultSetFactory() {
        return this.mappedResultSetFactory;
    }

    @Required
    public void setMappedResultSetFactory(XSLTMappedResultSetFactory mappedResultSetFactory) {
        this.mappedResultSetFactory = mappedResultSetFactory;
    }

    public Resource getXslt() {
        return this.xslt;
    }

    @Required
    public void setXslt(Resource xslt) {
        this.xslt = xslt;
    }

    public String getHostingDatasoureIdXpath() {
        return this.hostingDatasoureIdXpath;
    }

    @Required
    public void setHostingDatasoureIdXpath(String hostingDatasoureIdXpath) {
        this.hostingDatasoureIdXpath = hostingDatasoureIdXpath;
    }

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    @Required
    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }
}

