/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.compliance;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.manager.msro.wf.resultset.AbstractResultSetJobNode;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class PrepareCompliance
extends AbstractResultSetJobNode {
    private static final Log log = LogFactory.getLog(PrepareCompliance.class);
    private ServiceLocator<DatabaseService> dbServiceLocator;
    private String databaseName;
    private ResultSetClientFactory resultSetClientFactory;
    private String collectedDatasourceIdXpath;
    private String hostingDatasoureIdXpath;
    private Function<String, String> joiner = new Function<String, String>(){

        public String apply(String s) {
            return "'" + s + "'";
        }
    };
    private Predicate<String> filter = new Predicate<String>(){

        public boolean apply(String s) {
            return !s.trim().isEmpty();
        }
    };

    protected W3CEndpointReference evaluate(W3CEndpointReference epr) {
        HashSet idCache = Sets.newHashSet();
        SAXReader reader = new SAXReader();
        for (String record : this.getResultSetClientFactory().getClient(epr)) {
            Document doc = this.parseDocument(reader, record);
            String collectDsId = doc.valueOf(this.getCollectedDatasourceIdXpath());
            String hostingDsId = doc.valueOf(this.getHostingDatasoureIdXpath());
            idCache.add(collectDsId);
            idCache.add(hostingDsId);
        }
        String sql = "SELECT _dnet_resource_identifier_ FROM datasources WHERE datasourceid is null";
        Iterable filtered = Iterables.filter((Iterable)idCache, this.filter);
        log.info((Object)("compliance prepared for " + Iterables.size((Iterable)filtered) + " datasources"));
        String values = Joiner.on((String)", ").join(Iterables.transform((Iterable)filtered, this.joiner));
        if (!values.isEmpty()) {
            sql = "SELECT _dnet_resource_identifier_ FROM datasources WHERE datasourceid = any(ARRAY[" + values + "])";
            String update = "UPDATE datasources SET openairecompliant = 'true' WHERE datasourceid = any(ARRAY[" + values + "])";
            log.info((Object)update);
            ((DatabaseService)this.getDbServiceLocator().getService()).updateSQL(this.getDatabaseName(), update);
        }
        log.debug((Object)sql);
        return ((DatabaseService)this.getDbServiceLocator().getService()).searchSQL(this.getDatabaseName(), sql);
    }

    private Document parseDocument(SAXReader reader, String record) {
        try {
            return reader.read((Reader)new StringReader(record));
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    public String getCollectedDatasourceIdXpath() {
        return this.collectedDatasourceIdXpath;
    }

    @Required
    public void setCollectedDatasourceIdXpath(String collectedDatasourceIdXpath) {
        this.collectedDatasourceIdXpath = collectedDatasourceIdXpath;
    }

    public String getHostingDatasoureIdXpath() {
        return this.hostingDatasoureIdXpath;
    }

    @Required
    public void setHostingDatasoureIdXpath(String hostingDatasoureIdXpath) {
        this.hostingDatasoureIdXpath = hostingDatasoureIdXpath;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public ServiceLocator<DatabaseService> getDbServiceLocator() {
        return this.dbServiceLocator;
    }

    @Required
    public void setDbServiceLocator(ServiceLocator<DatabaseService> dbServiceLocator) {
        this.dbServiceLocator = dbServiceLocator;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Required
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

