/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.action;

import com.google.common.collect.Lists;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.openaire.action.HarvestActions;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.workflow.BlackboardJobNode;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoreActions
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(HarvestActions.class);
    public static final List<String> ACTION_MANAGER_BB_PARAMS = Lists.newArrayList((Object[])new String[]{"ruleId", "set", "provenance", "trust", "nsprefix", "agentId", "agentName", "agentType"});
    @Resource
    private ServiceLocator<ISLookUpService> lookupLocator;

    protected String locateService() {
        String xquery = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='ActionManagerServiceResourceType']//RESOURCE_IDENTIFIER/@value/string()";
        log.info((Object)("locating service: " + xquery));
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(xquery);
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to find action manager service", e);
        }
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) {
        super.prepareJob(job, token);
        job.setAction("FEED");
        job.getParameters().put("epr", token.getEnv().getAttribute("rs_epr"));
        for (String name : ACTION_MANAGER_BB_PARAMS) {
            job.getParameters().put(name, token.getEnv().getAttribute(name));
        }
    }
}

