/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.action;

import com.google.common.collect.Iterables;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.openaire.action.StoreActions;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.workflow.BlackboardJobNode;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HarvestActions
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(HarvestActions.class);
    @Resource
    private ServiceLocator<ISLookUpService> lookupLocator;

    protected String locateService() {
        String xquery = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='HarvestingServiceResourceType' and .//PROPERTY/@key='protocol' and .//PROPERTY/@value='filesystem']//RESOURCE_IDENTIFIER/@value/string()";
        log.info((Object)("locating service: " + xquery));
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(xquery);
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to find harvesting service", e);
        }
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) {
        super.prepareJob(job, token);
        try {
            String baseUrl = this.readServiceProperty("localPath");
            for (String name : StoreActions.ACTION_MANAGER_BB_PARAMS) {
                token.getEnv().setAttribute(name, this.readServiceProperty(name));
            }
            job.setAction("LISTRECORDS");
            job.getParameters().put("base_url", baseUrl);
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException("unable to find actions local path", e);
        }
    }

    private String readServiceProperty(String name) throws ISLookUpException {
        String xquery = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='ActionManagerServiceResourceType']//PROPERTY[./@key='" + name + "']/@value/string()";
        log.info((Object)("locating local actions param: " + xquery));
        return (String)Iterables.getOnlyElement((Iterable)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(xquery));
    }
}

