/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.workflow.AbstractJobNode;
import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class PrefetchResultsetJob
extends AbstractJobNode {
    private static final int PAGE_SIZE = 100;
    private static final Log log = LogFactory.getLog(PrefetchResultsetJob.class);
    private ServiceResolver serviceResolver;
    private DataSourceResolver dataSourceResolver;

    public void execute(Engine engine, NodeToken token) {
        String descriptor = token.getEnv().getAttribute("dataSource");
        try {
            this.fillPush(this.dataSourceResolver.resolve(descriptor).retrieve());
            super.execute(engine, token);
        }
        catch (Throwable e) {
            this.failed(engine, token, e);
        }
    }

    private W3CEndpointReference fillPush(W3CEndpointReference epr) throws ResultSetException {
        ResultSetService resultSet = (ResultSetService)this.serviceResolver.getService(ResultSetService.class, epr);
        String rsId = this.serviceResolver.getResourceIdentifier(epr);
        int total = 0;
        boolean allDone = false;
        int obtained = 0;
        while (true) {
            total = resultSet.getNumberOfElements(rsId);
            allDone = resultSet.getRSStatus(rsId).equals("closed");
            if (obtained < total && allDone) {
                log.info((Object)("prefetching " + (obtained + 1)));
                this.prefetchResult(resultSet, rsId, obtained + 1, total + 1);
                break;
            }
            if (allDone) break;
            log.info((Object)("prefetching 100 elements from " + (obtained + 1)));
            this.prefetchResult(resultSet, rsId, obtained + 1, obtained + 100);
            obtained += 100;
        }
        return epr;
    }

    protected void prefetchResult(ResultSetService resultSet, String rsId, int fromPosition, int toPosition) throws ResultSetException {
        for (int i = 1; i < 10; ++i) {
            try {
                resultSet.getResult(rsId, fromPosition, toPosition, "WAITING");
                return;
            }
            catch (SOAPFaultException e) {
                try {
                    String status = resultSet.getRSStatus(rsId);
                    log.info((Object)("prefetch didn't receive any data, waiting " + i + " seconds. Status: '" + status + "'"));
                    if (!"open".equals(status)) {
                        return;
                    }
                    log.info((Object)("sleeping " + 1000 * (i * i / 2)));
                    Thread.sleep(1000 * (i * i / 2));
                }
                catch (InterruptedException e1) {
                    log.debug((Object)"who woke me up ?!", (Throwable)e1);
                }
                continue;
            }
        }
        log.fatal((Object)"prefetch took too long waiting for object packaging service");
        throw new IllegalStateException("prefetch took too long waiting for object packaging service to split");
    }

    public ServiceResolver getServiceResolver() {
        return this.serviceResolver;
    }

    @Required
    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }

    public DataSourceResolver getDataSourceResolver() {
        return this.dataSourceResolver;
    }

    public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
        this.dataSourceResolver = dataSourceResolver;
    }
}

