/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.wf.SinkSourceParser;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.StringOpaqueResource;
import eu.dnetlib.workflow.AbstractJobNode;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.springframework.beans.factory.annotation.Required;
import org.w3c.dom.NodeList;

public class FindMDStore
extends AbstractJobNode {
    private ServiceLocator<ISLookUpService> lookupLocator;
    private SinkSourceParser sinkSourceParser;
    private String mdFormat;
    private String mdstoreXPath = "//DATA_SINK";
    private String inputAttribute = "hdsId";

    public void execute(Engine engine, NodeToken token) {
        try {
            String hiBody = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfile(token.getEnv().getAttribute(this.getInputAttribute()));
            XPath xpath = XPathFactory.newInstance().newXPath();
            this.defineFunctions(xpath);
            String descriptor = xpath.evaluate(this.mdstoreXPath, new StringOpaqueResource(hiBody).asDom());
            String mdId = descriptor.startsWith("dnet:") ? this.sinkSourceParser.getId(descriptor) : descriptor;
            String sinkSource = descriptor.startsWith("dnet:") ? descriptor : "dnet://MDStore/" + mdId;
            token.getEnv().setAttribute("mdId", mdId);
            token.getEnv().setAttribute("dataSink", sinkSource);
            token.getEnv().setAttribute("dataSource", sinkSource);
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (Exception e) {
            this.failed(engine, token, e);
        }
    }

    private void defineFunctions(XPath xpath) {
        xpath.setXPathFunctionResolver(new XPathFunctionResolver(){

            @Override
            public XPathFunction resolveFunction(QName name, int arity) {
                if (name.getNamespaceURI().equals("str") && name.getLocalPart().equals("replace")) {
                    return new XPathFunction(){

                        public Object evaluate(List args) throws XPathFunctionException {
                            String txt = ((NodeList)args.get(0)).item(0).getTextContent();
                            return txt.replaceAll((String)args.get(1), (String)args.get(2));
                        }
                    };
                }
                return null;
            }
        });
    }

    public String getMdFormat() {
        return this.mdFormat;
    }

    public void setMdFormat(String mdFormat) {
        this.mdFormat = mdFormat;
    }

    @Required
    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public SinkSourceParser getSinkSourceParser() {
        return this.sinkSourceParser;
    }

    public void setSinkSourceParser(SinkSourceParser sinkSourceParser) {
        this.sinkSourceParser = sinkSourceParser;
    }

    public String getMdstoreXPath() {
        return this.mdstoreXPath;
    }

    public void setMdstoreXPath(String mdstoreXPath) {
        this.mdstoreXPath = mdstoreXPath;
    }

    public String getInputAttribute() {
        return this.inputAttribute;
    }

    public void setInputAttribute(String inputAttribute) {
        this.inputAttribute = inputAttribute;
    }
}

