/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools;

import eu.dnetlib.enabling.tools.Schedulable;
import java.text.ParseException;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.quartz.CronExpression;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractSchedulable
implements Schedulable,
Job,
BeanNameAware {
    private static final String THIS = "this";
    private static final String GROUP = "schedulableJobs";
    private boolean enabled;
    private CronExpression cronExpression;
    private String beanName;
    @Resource(name="dnetJobScheduler")
    private Scheduler jobScheduler;

    @PostConstruct
    protected void init() {
        try {
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put((Object)THIS, (Object)this);
            JobDetail jd = new JobDetail();
            jd.setName(this.getBeanName());
            jd.setGroup(GROUP);
            jd.setJobDataMap(jobDataMap);
            jd.setJobClass(this.getClass());
            this.jobScheduler.scheduleJob(jd, this.createTrigger());
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private Trigger createTrigger() {
        try {
            CronTrigger trigger = new CronTrigger(this.getBeanName(), GROUP, this.getCronExpression());
            trigger.setMisfireInstruction(0);
            trigger.setJobGroup(GROUP);
            trigger.setJobName(this.getBeanName());
            return trigger;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("invalid cron expression: " + this.cronExpression, e);
        }
    }

    protected abstract void doExecute();

    @Override
    public void execute() {
        if (this.isEnabled()) {
            this.doExecute();
        }
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        AbstractSchedulable bean = (AbstractSchedulable)context.getJobDetail().getJobDataMap().get((Object)THIS);
        if (bean.isEnabled()) {
            bean.doExecute();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getCronExpression() {
        return this.cronExpression.getCronExpression();
    }

    @Required
    public void setCronExpression(String cronExpression) {
        try {
            this.cronExpression = new CronExpression(cronExpression);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("invalid cron expression: " + cronExpression, e);
        }
    }

    @Override
    public void updateCronExpression(String cronExpression) {
        if (!cronExpression.equals(this.getCronExpression())) {
            this.setCronExpression(cronExpression);
            try {
                this.jobScheduler.rescheduleJob(this.getBeanName(), GROUP, this.createTrigger());
            }
            catch (SchedulerException e) {
                throw new RuntimeException("unable to reschedule trigger", e);
            }
        }
    }

    @Override
    public String getNextFireTime() {
        try {
            if (this.isPaused()) {
                return "";
            }
            if (!this.isEnabled()) {
                return "";
            }
            Trigger t = this.jobScheduler.getTrigger(this.getBeanName(), GROUP);
            return t != null ? t.getNextFireTime().toString() : "";
        }
        catch (SchedulerException e) {
            throw new RuntimeException("unable to get trigger", e);
        }
    }

    @Override
    public boolean isPaused() {
        try {
            int state = this.jobScheduler.getTriggerState(this.getBeanName(), GROUP);
            switch (state) {
                case -1: 
                case 1: 
                case 3: {
                    return true;
                }
            }
            return false;
        }
        catch (SchedulerException e) {
            throw new RuntimeException("unable to get trigger", e);
        }
    }

    @Override
    public void pause() {
        try {
            this.jobScheduler.pauseTrigger(this.getBeanName(), GROUP);
        }
        catch (SchedulerException e) {
            throw new RuntimeException("unable to pause trigger", e);
        }
    }

    @Override
    public void resume() {
        try {
            this.jobScheduler.resumeTrigger(this.getBeanName(), GROUP);
        }
        catch (SchedulerException e) {
            throw new RuntimeException("unable to resume trigger", e);
        }
    }

    public String getBeanName() {
        return this.beanName;
    }

    @Required
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }
}

