/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb.utils;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.data.mdstore.modular.mongodb.MongoMDStore;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.ws.Endpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class MetadataCheckJob {
    private static final Log log = LogFactory.getLog(MetadataCheckJob.class);
    private ServiceLocator<ISLookUpService> lookupLocator;
    private Endpoint endpoint;
    private EndpointReferenceBuilder<Endpoint> eprBuilder;
    private MDStoreDao dao;
    private boolean runOnStart;

    public void runOnStart() {
        if (this.isRunOnStart()) {
            log.info((Object)"running mdStore metadata check on service start");
            this.repairMetadata();
        }
    }

    public void repairMetadata() {
        DBCollection metadata = ((MongoMDStore)this.getDao().getMDStore("metadata")).getCollection();
        if (metadata.findOne() != null) {
            log.debug((Object)"\n mdStore metadata doesn't need to be repaired");
            return;
        }
        try {
            List mdStores = ((ISLookUpService)this.getLookupLocator().getService()).quickSearchProfile("//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='MDStoreDSResourceType' and .//RESOURCE_URI/@value='" + this.getServiceAddress() + "']");
            log.debug((Object)"\n repairing mdstore metadata");
            for (String MDStoreProfile : mdStores) {
                metadata.save(this.getMdInfo(MDStoreProfile));
            }
            log.debug((Object)"\n FINISHED repairing mdstore metadata");
        }
        catch (ISLookUpException e) {
            throw new RuntimeException(e);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    private DBObject getMdInfo(String MDStoreProfile) throws DocumentException {
        Document doc = new SAXReader().read((Reader)new StringReader(MDStoreProfile));
        BasicDBObject dbo = new BasicDBObject();
        dbo.put("mdId", (Object)doc.valueOf("//RESOURCE_IDENTIFIER/@value"));
        dbo.put("format", (Object)doc.valueOf("//METADATA_FORMAT/text()"));
        dbo.put("layout", (Object)doc.valueOf("//METADATA_FORMAT_LAYOUT/text()"));
        dbo.put("interpretation", (Object)doc.valueOf("//METADATA_FORMAT_INTERPRETATION/text()"));
        return dbo;
    }

    private String getServiceAddress() {
        return this.getEprBuilder().getAddress((Object)this.getEndpoint()) + "?wsdl";
    }

    @Required
    public void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
        this.eprBuilder = eprBuilder;
    }

    public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
        return this.eprBuilder;
    }

    @Required
    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Required
    public void setDao(MDStoreDao dao) {
        this.dao = dao;
    }

    public MDStoreDao getDao() {
        return this.dao;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setRunOnStart(boolean runOnStart) {
        this.runOnStart = runOnStart;
    }

    public boolean isRunOnStart() {
        return this.runOnStart;
    }
}

