/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import eu.dnetlib.enabling.resultset.ResultSet;
import eu.dnetlib.enabling.resultset.ResultSetAware;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.maps.ConcurrentSizedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MongoResultSetListener
implements ResultSetListener,
ResultSetAware {
    private static final Log log = LogFactory.getLog(MongoResultSetListener.class);
    private ConcurrentSizedMap<Integer, String> lastKeys = new ConcurrentSizedMap();
    private final DBObject byId = new BasicDBObject("id", (Object)1);
    private UnaryFunction<String, DBObject> serializer;
    private Pattern filter;
    private DBCollection collection;

    public MongoResultSetListener(DBCollection collection, Pattern filter, UnaryFunction<String, DBObject> serializer) {
        this.collection = collection;
        this.filter = filter;
        this.serializer = serializer;
    }

    public List<String> getResult(int fromPosition, int toPosition) {
        ArrayList<DBObject> page = null;
        String lastKey = (String)this.lastKeys.get((Object)fromPosition);
        page = lastKey != null ? this.continueFrom(lastKey, toPosition - fromPosition + 1) : this.fetchNew(fromPosition - 1, toPosition - fromPosition + 1);
        if (!page.isEmpty()) {
            DBObject last = page.get(page.size() - 1);
            this.lastKeys.put((Object)(toPosition + 1), (Object)((String)last.get("id")));
        }
        return MappedCollection.listMap(page, this.serializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<DBObject> fetchNew(int from, int size) {
        DBCursor cursor = null;
        if (this.filter != null) {
            DBObject query = QueryBuilder.start((String)"body").regex(this.filter).get();
            cursor = this.collection.find(query).sort(this.byId);
        } else {
            cursor = this.collection.find().sort(this.byId);
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)cursor.skip(from).limit(size));
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<DBObject> continueFrom(String lastKey, int size) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("trying to continue from previous key: " + lastKey));
        }
        DBObject query = null;
        query = this.filter != null ? QueryBuilder.start((String)"id").greaterThan((Object)lastKey).and("body").regex(this.filter).get() : QueryBuilder.start((String)"id").greaterThan((Object)lastKey).get();
        DBCursor cursor = this.collection.find(query).sort(this.byId);
        ArrayList arrayList = Lists.newArrayList((Iterable)cursor.limit(size));
        return arrayList;
    }

    public int getSize() {
        if (this.filter != null) {
            DBObject query = QueryBuilder.start((String)"body").regex(this.filter).get();
            return this.collection.find(query).count();
        }
        return (int)this.collection.getCount();
    }

    public void setResultSet(ResultSet resultSet) {
        resultSet.close();
    }
}

