/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.inspector;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.mdstore.modular.MDStoreFeeder;
import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.data.mdstore.modular.mongodb.MongoMDStore;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.string.EscapeHtml;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class MDStoreInspector
extends AbstractInspectorController {
    private static final Log log = LogFactory.getLog(MDStoreInspector.class);
    @Resource(name="mongodbMDStoreDao")
    private MDStoreDao mdstoreDao;
    @Resource
    private MDStoreFeeder feeder;

    @RequestMapping(value={"/inspector/mdstores.do"})
    public void mdstores(Model model) {
        model.addAttribute("mdstores", (Object)MappedCollection.listMap((Iterable)this.mdstoreDao.listMDStores(), (UnaryFunction)new UnaryFunction<MDStoreDescription, String>(){

            public MDStoreDescription evaluate(String arg) {
                MDStore mdstore = MDStoreInspector.this.mdstoreDao.getMDStore(arg);
                return new MDStoreDescription(arg, mdstore.getSize());
            }
        }));
    }

    @RequestMapping(value={"/inspector/mdstore.do"}, method={RequestMethod.GET})
    public void mdstore(Model model, @RequestParam(value="id") String id, @RequestParam(value="start", required=false) Integer startParam, @RequestParam(value="regex", required=false) String regex) {
        int pageSize = 10;
        int start = 0;
        if (startParam != null) {
            start = startParam;
        }
        MDStore mdstore = this.mdstoreDao.getMDStore(id);
        ResultSetListener rs = mdstore.deliver(null, null, regex);
        List page = rs.getResult(1 + start, start + pageSize);
        model.addAttribute("id", (Object)id);
        model.addAttribute("start", (Object)start);
        model.addAttribute("regex", (Object)regex);
        model.addAttribute("nextPage", (Object)(start + pageSize));
        model.addAttribute("prevPage", (Object)Math.max(0, start - pageSize));
        model.addAttribute("size", (Object)rs.getSize());
        model.addAttribute("page", (Object)MappedCollection.listMap((Iterable)page, (UnaryFunction)new EscapeHtml()));
    }

    @RequestMapping(value={"/inspector/mdstore.do"}, method={RequestMethod.POST})
    public String bulkReplace(Model model, @RequestParam(value="id") String id, @RequestParam(value="regex") String regex, @RequestParam(value="replace") String replace, @RequestParam(value="checkReplace", required=false) Boolean checkReplace) {
        boolean replaceEnable;
        log.debug((Object)("regex: " + regex));
        log.debug((Object)("replace: " + replace));
        MongoMDStore mdstore = (MongoMDStore)this.mdstoreDao.getMDStore(id);
        boolean bl = replaceEnable = checkReplace != null && checkReplace == true;
        if (replaceEnable) {
            mdstore.replace(regex, replace);
        } else {
            model.addAttribute("regex", (Object)regex);
        }
        return "redirect:mdstore.do?id=" + id;
    }

    @RequestMapping(value={"/inspector/mdstoreEditResult.do"})
    public void mdstoreEditRecord(Model model, @RequestParam(value="id") String id, @RequestParam(value="start") int start, @RequestParam(value="index") int index) {
        MDStore mdstore = this.mdstoreDao.getMDStore(id);
        ResultSetListener rs = mdstore.deliver(null, null, null);
        List page = rs.getResult(1 + index + start, 1 + index + start);
        model.addAttribute("id", (Object)id);
        model.addAttribute("start", (Object)start);
        model.addAttribute("record", (Object)new EscapeHtml().evaluate((String)Iterables.getOnlyElement((Iterable)page)));
    }

    @RequestMapping(value={"/inspector/mdstoreSaveRecord.do"})
    public String mdstoreSaveRecord(Model model, @RequestParam(value="id") String id, @RequestParam(value="start") int start, @RequestParam(value="record") String record) {
        MDStore mdstore = this.mdstoreDao.getMDStore(id);
        mdstore.feed((Iterable)Lists.newArrayList((Object[])new String[]{record}), true);
        return "redirect:mdstore.do?id=" + id + "&start=" + start;
    }

    @RequestMapping(value={"/inspector/mdstoreDeleteRecord.do"})
    public String mdstoreDeleteRecord(Model model, @RequestParam(value="id") String id, @RequestParam(value="start") int start, @RequestParam(value="index") int index) {
        MDStore mdstore = this.mdstoreDao.getMDStore(id);
        ResultSetListener rs = mdstore.deliverIds(null, null, null);
        List page = rs.getResult(1 + index + start, 1 + index + start);
        String recordId = (String)Iterables.getOnlyElement((Iterable)page);
        log.fatal((Object)("deleting record " + recordId));
        mdstore.deleteRecord(recordId);
        return "redirect:mdstore.do?id=" + id + "&start=" + start;
    }

    @RequestMapping(value={"/inspector/mdstoresRefreshSizes.do"})
    public String mdstoresRefreshSizes(Model model) {
        for (String mdId : this.mdstoreDao.listMDStores()) {
            this.feeder.touchSize(mdId, this.mdstoreDao.getMDStore(mdId).getSize());
        }
        return "redirect:mdstores.do";
    }

    @RequestMapping(value={"/inspector/ensure.do"})
    public String mdstoreEnsureIndex(Model model, @RequestParam(value="id") String id) {
        MongoMDStore mdStore = (MongoMDStore)this.mdstoreDao.getMDStore(id);
        log.info((Object)("manual ensureIndex for mdId: " + id));
        mdStore.ensureIndices();
        return "redirect:mdstores.do";
    }

    class MDStoreDescription {
        private String id;
        private int size;

        public MDStoreDescription(String id, int size) {
            this.id = id;
            this.size = size;
        }

        public String getFormat() {
            return MDStoreInspector.this.mdstoreDao.getMDStore(this.id).getFormat();
        }

        public String getLayout() {
            return MDStoreInspector.this.mdstoreDao.getMDStore(this.id).getLayout();
        }

        public String getInterpretation() {
            return MDStoreInspector.this.mdstoreDao.getMDStore(this.id).getInterpretation();
        }

        public boolean getIndexed() {
            return ((MongoMDStore)MDStoreInspector.this.mdstoreDao.getMDStore(this.id)).isIndexed();
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }
}

