String.prototype.replaceAll = function(from, to ) {
    var idx = this.indexOf( from );
	var str = this;

    while ( idx > -1 ) {
        str = str.replace( from, to );
        idx = str.indexOf( from );
    }

    return str;
}

String.prototype.trim = function() {
	return this.replace(/^\s+|\s+$/g,"");
}
String.prototype.ltrim = function() {
	return this.replace(/^\s+/,"");
}
String.prototype.rtrim = function() {
	return this.replace(/\s+$/,"");
}
function ltrim(str) {
	for(var k = 0; k < str.length && isWhitespace(str.charAt(k)); k++);
	return str.substring(k, str.length);
}
function rtrim(str) {
	for(var j=str.length-1; j>=0 && isWhitespace(str.charAt(j)) ; j--) ;
	return str.substring(0,j+1);
}
function trim(str) {
	return ltrim(rtrim(str));
}
function isWhitespace(charToCheck) {
	var whitespaceChars = " \t\n\r\f";
	return (whitespaceChars.indexOf(charToCheck) != -1);
}
function updateTrimText() {
	formObj = document.forms['trimExampleForm'];
	formObj.trimText.value = '++'+trim(formObj.userInput.value)+'++';
	formObj.ltrimText.value = '++'+ltrim(formObj.userInput.value)+'++';
	formObj.rtrimText.value = '++'+rtrim(formObj.userInput.value)+'++';
}
function initpage() {
	updateTrimText();
}

function send_query(query) {

	PageNumber = window.location.hash.substring(1);

	$('ajax_icon').style.display = '';
	new Ajax.Request('query.do', {
			method: 'post',
			parameters: "section=2&query=" + query + "&PageNumber=" + PageNumber,
			onSuccess: function(req) {
				var html = req.responseText;
	      		$('records').innerHTML = html.trim();
	      		$('ajax_icon').style.display = 'none';
	      	},
	      	on404: function(req) {
	      		//alert("file not found");
	      		$('ajax_icon').style.display = 'none';
	      		$('records').innerHTML = '<ul class="plain"><li>No Results (file not found)</li></ul>'
	      	 },
	      	on500: function(req) {
	      		//alert("something went wrong");
	      		$('ajax_icon').style.display = 'none';
	      		$('records').innerHTML = '<ul class="plain"><li>No Results (error)</li></ul>'
	      	}
		}
	);
}

function get_browse_stats(query) {
	$('browse_stats').innerHTML = "Loading...";
	new Ajax.Request('browseStats.do', {
			method: 'post',
			parameters: "section=2&query=" + query,
			onSuccess: function(req) {
				var html = req.responseText;
	      		$('browse_stats').innerHTML = html.trim();
	      	},
	      	on404: function(req) {
	      		$('browse_stats').innerHTML = '<i>empty</i>'
	      	 },
	      	on500: function(req) {
	      		$('browse_stats').innerHTML = '<i>error</i>'
	      	}
		}
	);
}

function next_page (rsId, PageNumber, resultset_address) {

	$('ajax_icon').style.display = '';

	new Ajax.Request('query.do', {
			method: 'post',
			parameters: "section=3&rsId="+rsId +"&PageNumber="+PageNumber+"&resultset_address="+resultset_address,
			onSuccess: function(req) {
				var html = req.responseText;
	      		$('records').innerHTML = html.trim();
	      		$('ajax_icon').style.display = 'none';
	      	},
	      	on404: function(req) {
	      		alert("file not found");
	      		$('records').innerHTML = '<ul class="plain"><li>No Results</li></ul>';
	      		$('ajax_icon').style.display = 'none';
	      	 },
	      	on500: function(req) {
	      		alert("something went wrong");
	      		$('records').innerHTML = '<ul class="plain"><li>No Results</li></ul>';
	      		$('ajax_icon').style.display = 'none';
	      	}
		}
	);
}

function viewDocument (rsId, position, PageNumber, resultset_address) {
	window.location = "index.jsp?section=document&rsId="+rsId+"&position="+position+"&PageNumber="+PageNumber+"&resultset_address="+escape(resultset_address);
}
function returnPage (rsId, PageNumber, resultset_address) {
	window.location = "index.jsp?noquery=yes&section=results&rsId="+rsId+"&PageNumber="+PageNumber+"&resultset_address="+escape(resultset_address);
}

function switchContentTable(tbody1, tbody2) {
	document.getElementById(tbody1).style.visibility="collapse";
	document.getElementById(tbody1).style.display="none";
	document.getElementById(tbody2).style.visibility="visible";
	document.getElementById(tbody2).style.display="table-row-group";
}
