<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<!-- derived from DMF -->

	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
		<xsl:apply-templates select="//metadata"/>
	</xsl:template>
	
	<xsl:template match="//metadata">
	
		<xsl:variable name = "link" select = "*[name()='dr:repositoryLink']"></xsl:variable>
	
		<xsl:for-each select="*[name()='dc:title']">
			<span class="title">
			<a href="{../*[name()='dc:identifier']}"><xsl:value-of select="."></xsl:value-of></a>
			</span>
			<br/>
		</xsl:for-each>
		<div class="recordContents">
			<xsl:for-each select="*[name()='dc:creator']">
				<span class="author">
					<xsl:value-of select="."></xsl:value-of>
				</span>
				<br/>
			</xsl:for-each>
			<xsl:for-each select="*[name()='dc:dateAccepted']">
				<xsl:value-of select="."/>
				<br/>
			</xsl:for-each>
			<!-- 
			<xsl:for-each select="*[name()='dr:repositoryName']">
				<a href="{$link}" ><xsl:value-of select="."/></a><br/>
			</xsl:for-each> -->
			Project: <xsl:value-of select="oaf:projectname"/><br/>
		</div>
	</xsl:template>
</xsl:stylesheet>
