/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.simplesso;

import eu.dnetlib.simplesso.SimpleSSOAuthenticationRoleBuilder;
import eu.dnetlib.simplesso.SimpleSSOAuthenticationToken;
import eu.dnetlib.simplesso.SimpleSSOAuthenticator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.providers.AuthenticationProvider;

public class SimpleSSOAuthenticationProvider
implements AuthenticationProvider {
    private static final Log log = LogFactory.getLog(SimpleSSOAuthenticationProvider.class);
    private SimpleSSOAuthenticator authenticator;
    private SimpleSSOAuthenticationRoleBuilder rolesBuilder;

    public Authentication authenticate(Authentication auth) throws AuthenticationException {
        log.debug((Object)("SSO authenticating " + auth));
        if (auth.isAuthenticated()) {
            log.debug((Object)("already authenticated, trusting " + auth));
            return auth;
        }
        if (auth instanceof SimpleSSOAuthenticationToken) {
            SimpleSSOAuthenticationToken reqAuth = (SimpleSSOAuthenticationToken)auth;
            SimpleSSOAuthenticator.AuthPayload payload = this.authenticator.decodeToken(reqAuth.getToken());
            if (payload == null) {
                return null;
            }
            GrantedAuthority[] grantedAuthorities = this.rolesBuilder.buildAuthorities(payload.getRoles());
            SimpleSSOAuthenticationToken res = new SimpleSSOAuthenticationToken(reqAuth.getToken(), grantedAuthorities);
            res.setUid(payload.getUid());
            return res;
        }
        log.warn((Object)("not handling " + auth));
        return null;
    }

    public boolean supports(Class arg0) {
        return true;
    }

    @Required
    public void setAuthenticator(SimpleSSOAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public SimpleSSOAuthenticationRoleBuilder getRolesBuilder() {
        return this.rolesBuilder;
    }

    public void setRolesBuilder(SimpleSSOAuthenticationRoleBuilder rolesBuilder) {
        this.rolesBuilder = rolesBuilder;
    }

    public SimpleSSOAuthenticator getAuthenticator() {
        return this.authenticator;
    }
}

