/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.simplesso;

import eu.dnetlib.simplesso.SimpleSSOAuthenticationRoleBuilder;
import eu.dnetlib.simplesso.SimpleSSOAuthenticationToken;
import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;
import org.springframework.security.ui.AbstractProcessingFilter;

public class SimpleSSOAuthenticationFilter
extends AbstractProcessingFilter {
    private static final Log log = LogFactory.getLog(SimpleSSOAuthenticationFilter.class);
    private boolean enabled = false;
    private SimpleSSOAuthenticationRoleBuilder rolesBuilder;
    private List<String> anonymousRoles;

    public int getOrder() {
        return 0;
    }

    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.requiresAuthentication(request, response)) {
            Authentication authResult;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Request is to process authentication");
            }
            try {
                this.onPreAuthentication(request, response);
                authResult = this.attemptAuthentication(request);
            }
            catch (AuthenticationException failed) {
                this.unsuccessfulAuthentication(request, response, failed);
                return;
            }
            this.successfulAuthentication(request, response, authResult);
            if (this.enabled) {
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public Authentication attemptAuthentication(HttpServletRequest request) throws AuthenticationException {
        Object authRequest = this.enabled ? this.ssoAuth(request) : this.anonymousAuth();
        Authentication res = this.getAuthenticationManager().authenticate(authRequest);
        if (!this.enabled) {
            log.debug((Object)("Setting HACK auth " + res));
            SecurityContextHolder.getContext().setAuthentication(res);
        }
        return res;
    }

    public String getDefaultFilterProcessesUrl() {
        return "/auth";
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        if (!this.enabled) {
            if (SecurityContextHolder.getContext().getAuthentication() != null) {
                log.debug((Object)("already have some auth token " + SecurityContextHolder.getContext().getAuthentication()));
                return false;
            }
            return true;
        }
        String authParam = request.getParameter("auth");
        return authParam != null && !authParam.equals("");
    }

    protected SimpleSSOAuthenticationToken ssoAuth(HttpServletRequest request) {
        return new SimpleSSOAuthenticationToken(request.getParameter("auth"));
    }

    protected Authentication anonymousAuth() {
        return new AnonymousAuthenticationToken("disabled", (Object)"anonymous", this.rolesBuilder.buildAuthorities(this.anonymousRoles));
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException, ServletException {
        if (this.enabled) {
            super.successfulAuthentication(request, response, authResult);
        } else {
            log.debug((Object)("SETTING AUTHENTICATION " + authResult));
            SecurityContextHolder.getContext().setAuthentication(authResult);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public SimpleSSOAuthenticationRoleBuilder getRolesBuilder() {
        return this.rolesBuilder;
    }

    public void setRolesBuilder(SimpleSSOAuthenticationRoleBuilder rolesBuilder) {
        this.rolesBuilder = rolesBuilder;
    }

    public List<String> getAnonymousRoles() {
        return this.anonymousRoles;
    }

    public void setAnonymousRoles(List<String> anonymousRoles) {
        this.anonymousRoles = anonymousRoles;
    }
}

