/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.simplesso;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.AuthenticationException;
import org.springframework.security.ui.AuthenticationEntryPoint;

public class SimpleSSOAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private static final Log log = LogFactory.getLog(SimpleSSOAuthenticationEntryPoint.class);
    private String authUrl;
    private boolean enabled = false;

    public void commence(ServletRequest request, ServletResponse response, AuthenticationException ex) throws IOException, ServletException {
        if (!this.enabled) {
            log.error((Object)"sso disabled but anon auth failed, sending error", (Throwable)ex);
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendError(403, "Access Denied");
        } else {
            log.debug((Object)"redirecting to auth server");
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String redirectUrl = this.authUrl + "?url=" + URLEncoder.encode(httpRequest.getRequestURL().toString(), "UTF-8");
            httpResponse.sendRedirect(redirectUrl);
        }
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

