/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.lightui.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class LightuiDefaultStaticFilesController {
    private final Map<String, String> extToMime = new HashMap<String, String>();
    private static final Log log = LogFactory.getLog(LightuiDefaultStaticFilesController.class);

    public LightuiDefaultStaticFilesController() {
        this.extToMime.put("js", "text/javascript");
        this.extToMime.put("css", "text/css");
        this.extToMime.put("png", "image/png");
        this.extToMime.put("jpg", "image/jpeg");
        this.extToMime.put("gif", "image/gif");
    }

    @RequestMapping(value={"static.get"})
    public void stat(ServletResponse response, OutputStream out, @RequestParam(value="src", required=true) String src) throws Exception {
        if (this.renderStatic(response, out, src)) {
            log.info((Object)("Static file " + src));
        } else {
            log.warn((Object)("Static file " + src + " NOT FOUND"));
        }
    }

    protected boolean renderStatic(ServletResponse response, OutputStream output, String name) throws IOException {
        String ext = name.substring(name.lastIndexOf(46) + 1, name.length());
        String path = "/eu/dnetlib/functionality/lightui/web/resources/";
        path = ext.equalsIgnoreCase("js") ? path + "js/" : (ext.equalsIgnoreCase("css") ? path + "css/" : path + "images/");
        return this.renderStatic(response, output, this.getClass().getResourceAsStream(path + name), this.extToMime.get(ext));
    }

    protected boolean renderStatic(ServletResponse response, OutputStream output, InputStream input, String contentType) throws IOException {
        if (input != null) {
            response.setContentType(contentType);
            IOUtils.copy((InputStream)input, (OutputStream)output);
            return true;
        }
        return false;
    }
}

