/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.lightui.web;

import eu.dnetlib.data.index.IIndexService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.functionality.lightui.utils.EPRUtil;
import eu.dnetlib.functionality.lightui.utils.ResultSet;
import eu.dnetlib.functionality.lightui.utils.ResultSetFactory;
import eu.dnetlib.functionality.lightui.web.SearchEngine;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class AsynchronousSearchEngine
implements SearchEngine {
    protected Log log = LogFactory.getLog(AsynchronousSearchEngine.class);
    protected ServiceLocator<IIndexService> indexLocator;
    protected ExecutorService executor = Executors.newFixedThreadPool(8);
    protected Cache resultSetByQueryCache;
    protected Cache resultSetByEprCache;
    private boolean withHighlight;
    private String defaultQuery;
    @Resource(name="lightuiResultSetFactory")
    protected ResultSetFactory resultSetFactory;

    @Override
    public ResultSet resultSetForQueryOrEpr(String query, String metadataFormat, W3CEndpointReference epr) {
        if (epr == null) {
            try {
                String q = "";
                if (this.withHighlight && !query.trim().equalsIgnoreCase(this.defaultQuery.trim())) {
                    q = ">solr=NAMESPACE solr.hl=true and ";
                }
                q = q + query;
                ResultSet rs = this.getFutureResultSetByQuery(q, metadataFormat).get();
                this.setResultSetByEpr(rs.getEpr(), rs);
                this.log.debug((Object)("executing query:" + q));
                return rs;
            }
            catch (InterruptedException e) {
                this.log.fatal((Object)e);
                return null;
            }
            catch (ExecutionException e) {
                this.log.fatal((Object)e);
                return null;
            }
        }
        return this.getResultSetByEpr(epr);
    }

    @Override
    public Future<ResultSet> prepareQuery(final String cqlQuery, final String metadataFormat) {
        this.log.info((Object)"SUBMITTING ASYNC");
        Future<ResultSet> rs = this.executor.submit(new Callable<ResultSet>(){

            @Override
            public ResultSet call() {
                ResultSet rs = null;
                try {
                    rs = AsynchronousSearchEngine.this.createResultSet(((IIndexService)AsynchronousSearchEngine.this.indexLocator.getService()).indexLookup("all", cqlQuery, metadataFormat, "index"));
                    rs.getNumberOfElements();
                }
                catch (Exception e) {
                    AsynchronousSearchEngine.this.log.error((Object)"Error prefetching page", (Throwable)e);
                }
                AsynchronousSearchEngine.this.log.debug((Object)"ASYNC FINISHED");
                return rs;
            }
        });
        this.setFutureResultSetByQuery(cqlQuery, rs);
        return rs;
    }

    protected ResultSet createResultSet(W3CEndpointReference epr) {
        return this.resultSetFactory.newInstance(epr);
    }

    protected Future<ResultSet> getFutureResultSetByQuery(String cqlQuery, String metadataFormat) {
        Element element = this.resultSetByQueryCache.get((Serializable)((Object)cqlQuery));
        if (element != null) {
            return (Future)element.getObjectValue();
        }
        this.log.info((Object)("no future resultset for query: " + cqlQuery));
        return this.prepareQuery(cqlQuery, metadataFormat);
    }

    protected void setFutureResultSetByQuery(String query, Future<ResultSet> future) {
        this.resultSetByQueryCache.put(new Element((Object)query, future));
    }

    protected ResultSet getResultSetByEpr(W3CEndpointReference epr) {
        return (ResultSet)this.resultSetByEprCache.get((Serializable)((Object)this.getEprKey(epr))).getObjectValue();
    }

    protected void setResultSetByEpr(W3CEndpointReference epr, ResultSet rs) {
        this.resultSetByEprCache.put(new Element((Object)this.getEprKey(epr), (Object)rs));
    }

    protected String getEprKey(W3CEndpointReference epr) {
        String rsId = EPRUtil.getResourceIdentifier(epr);
        String address = EPRUtil.getAddress(epr);
        return address + "." + rsId;
    }

    public ServiceLocator<IIndexService> getIndexLocator() {
        return this.indexLocator;
    }

    @Required
    public void setIndexLocator(ServiceLocator<IIndexService> indexLocator) {
        this.indexLocator = indexLocator;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    protected Cache getResultSetByQueryCache() {
        return this.resultSetByQueryCache;
    }

    public void setResultSetByQueryCache(Cache resultSetByQueryCache) {
        this.resultSetByQueryCache = resultSetByQueryCache;
    }

    protected Cache getResultSetByEprCache() {
        return this.resultSetByEprCache;
    }

    public void setResultSetByEprCache(Cache resultSetByEprCache) {
        this.resultSetByEprCache = resultSetByEprCache;
    }

    @Required
    public void setWithHighlight(boolean withHighlight) {
        this.withHighlight = withHighlight;
    }

    public boolean isWithHighlight() {
        return this.withHighlight;
    }

    public String getDefaultQuery() {
        return this.defaultQuery;
    }

    @Required
    public void setDefaultQuery(String defaultQuery) {
        this.defaultQuery = defaultQuery;
    }
}

