/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.lightui.utils;

import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.ServiceResolver;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSet {
    private static final Log log = LogFactory.getLog(ResultSet.class);
    private W3CEndpointReference epr;
    private Integer numberOfElements = null;
    private String rsId = null;
    private ServiceResolver serviceResolver;

    public ResultSet(W3CEndpointReference epr, ServiceResolver serviceResolver) {
        this.epr = epr;
        this.serviceResolver = serviceResolver;
        this.rsId = serviceResolver.getResourceIdentifier(epr);
    }

    public int getNumberOfElements() throws ResultSetException {
        ResultSetService resultset = (ResultSetService)this.serviceResolver.getService(ResultSetService.class, this.epr);
        if (this.numberOfElements == null) {
            this.numberOfElements = resultset.getNumberOfElements(this.rsId);
        }
        return this.numberOfElements;
    }

    public W3CEndpointReference getEpr() {
        return this.epr;
    }

    public void setEpr(W3CEndpointReference epr) {
        this.epr = epr;
    }

    public List<String> getResult(int fromPosition, int toPosition) throws ResultSetException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting result " + fromPosition + " -> " + toPosition));
        }
        ResultSetService resultset = (ResultSetService)this.serviceResolver.getService(ResultSetService.class, this.epr);
        log.debug((Object)"executing getResult ");
        return resultset.getResult(this.rsId, fromPosition, toPosition, "WAITING");
    }

    public ServiceResolver getServiceResolver() {
        return this.serviceResolver;
    }

    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }
}

