/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.lightui.utils;

import eu.dnetlib.functionality.lightui.utils.AbstractQueryBuilder;
import eu.dnetlib.functionality.lightui.utils.Base64Coder;
import eu.dnetlib.functionality.lightui.utils.QueryBuilder;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Required;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLParser;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.CQLTermNode;
import org.z3950.zing.cql.ModifierSet;

public class QueryBuilderImpl
extends AbstractQueryBuilder
implements QueryBuilder {
    private boolean useBbqs;
    final CQLParser parser = new CQLParser();

    @Override
    public CQLNode getQuery(Map<String, String[]> params) throws CQLParseException, IOException {
        String bbqName = null;
        ArrayList<Object> nodes = new ArrayList<Object>();
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue()[0];
            if (key.startsWith("_") || value.equals("")) continue;
            if (key.equalsIgnoreCase("allField")) {
                for (String token : value.split(" ")) {
                    nodes.add(this.parser.parse("\"" + token + "\""));
                }
                continue;
            }
            if (key.equalsIgnoreCase("language")) {
                nodes.add(new CQLTermNode(key, new CQLRelation("="), value));
                continue;
            }
            if (key.equalsIgnoreCase("repositoryName")) {
                String conditionSource = Base64Coder.decodeString(value);
                if (this.isUseBbqs() && conditionSource.length() > 100) {
                    MessageDigest messageDigest;
                    try {
                        messageDigest = MessageDigest.getInstance("MD5");
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IllegalStateException(e);
                    }
                    messageDigest.update(conditionSource.getBytes(), 0, conditionSource.length());
                    bbqName = new BigInteger(1, messageDigest.digest()).toString(16);
                }
                nodes.add(this.parser.parse(conditionSource));
                continue;
            }
            nodes.add(new CQLTermNode(key, new CQLRelation("any"), value));
        }
        ModifierSet plain = new ModifierSet("and");
        ModifierSet qualified = new ModifierSet("and");
        if (bbqName != null) {
            qualified.addModifier("driver.bbq", "=", bbqName);
        }
        int i = nodes.size() - 1;
        CQLNode query = null;
        for (CQLNode cQLNode : nodes) {
            if (query == null) {
                query = cQLNode;
                continue;
            }
            query = new CQLAndNode(cQLNode, query, i-- > 1 ? plain : qualified);
        }
        if (nodes.size() == 1 && bbqName != null) {
            query = new CQLAndNode(query, this.parser.parse("\"" + this.getDefaultQuery() + "\""), qualified);
        }
        return query;
    }

    @Override
    protected void handleField(Collection<CQLNode> nodes, String key, String value) throws CQLParseException, IOException {
    }

    @Override
    public boolean isUseBbqs() {
        return this.useBbqs;
    }

    @Override
    @Required
    public void setUseBbqs(boolean useBbqs) {
        this.useBbqs = useBbqs;
    }
}

