/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.lightui.utils;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.functionality.lightui.utils.DynamicDriverCollection;
import eu.dnetlib.functionality.lightui.utils.Repository;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class CountryDriverCollection
extends DynamicDriverCollection
implements BeanFactoryAware {
    public static Log log = LogFactory.getLog(CountryDriverCollection.class);
    private String country;
    private BeanFactory beanFactory;

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Override
    public Set<Repository> getRepositories() throws ISLookUpException {
        LinkedHashSet<Repository> repositories = new LinkedHashSet<Repository>();
        String query = "for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')//CONFIGURATION[COUNTRY='" + this.getCountry() + "']" + "return concat($x/OFFICIAL_NAME/text(),':-:', $x/ICON_URI,':-:',$x/REPOSITORY_WEBPAGE)";
        ArrayList reps = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(query);
        if (reps == null) {
            reps = new ArrayList();
        }
        for (String repositoryTuple : reps) {
            Object[] tuple = repositoryTuple.split(":-:");
            Repository rep = (Repository)this.beanFactory.getBean("repositoryImpl", tuple);
            repositories.add(rep);
        }
        return repositories;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

