/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.lightui.utils;

import eu.dnetlib.functionality.lightui.utils.QueryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLBBQNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLTermNode;
import org.z3950.zing.cql.ModifierSet;

public abstract class AbstractQueryBuilder
implements QueryBuilder {
    protected boolean useBbqs = false;
    private String defaultQuery = "textual";

    protected abstract void handleField(Collection<CQLNode> var1, String var2, String var3) throws CQLParseException, IOException;

    @Override
    public CQLNode getQuery(Map<String, String[]> params) throws CQLParseException, IOException {
        ArrayList<CQLNode> nodes = new ArrayList<CQLNode>();
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            String value = entry.getValue()[0];
            String key = entry.getKey().toLowerCase();
            if (key.startsWith("_")) continue;
            if (value.contains("||")) {
                value = value.substring(0, value.indexOf("||"));
            }
            if (value.equals("")) continue;
            this.handleField(nodes, key, value);
        }
        return this.buildConjunction(nodes);
    }

    protected CQLNode buildConjunction(Collection<CQLNode> nodes) throws CQLParseException, IOException {
        CQLNode query = null;
        CQLTermNode wildcardNode = new CQLTermNode(null, null, this.defaultQuery);
        for (CQLNode node : nodes) {
            query = this.chainNode(query, node);
        }
        if (this.isUseBbqs() && nodes.size() == 1 && query instanceof CQLBBQNode) {
            query = this.chainNode((CQLNode)wildcardNode, query);
        }
        if (query == null) {
            return wildcardNode;
        }
        return query;
    }

    private CQLNode chainNode(CQLNode query, CQLNode node) {
        if (query == null) {
            return node;
        }
        ModifierSet modifier = new ModifierSet("and");
        if (this.isUseBbqs() && node instanceof CQLBBQNode) {
            modifier.addModifier("driver.bbq", "=", ((CQLBBQNode)node).getBbqName());
        }
        return new CQLAndNode(node, query, modifier);
    }

    public boolean isUseBbqs() {
        return this.useBbqs;
    }

    public void setUseBbqs(boolean useBbqs) {
        this.useBbqs = useBbqs;
    }

    public String getDefaultQuery() {
        return this.defaultQuery;
    }

    public void setDefaultQuery(String defaultQuery) {
        this.defaultQuery = defaultQuery;
    }
}

