/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.lightui.formatter;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;

public class ResultFormatter {
    protected Log log = LogFactory.getLog(ResultFormatter.class);
    private Resource xsltResource;
    private TransformerFactory tFactory = TransformerFactory.newInstance();
    private Transformer transformer;
    private String openIndexTagHL = null;
    private String openHtmlTagHL = null;
    private String closeIndexTagHL = null;
    private String closeHtmlTagHL = null;

    protected ResultFormatter() {
    }

    @PostConstruct
    public void init(HttpSession session) {
        try {
            this.transformer = this.tFactory.newTransformer(new StreamSource(this.xsltResource.getInputStream()));
            this.setSessionParameters(session);
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String viewDocument(String docXML) {
        try {
            this.log.debug((Object)"start transforming row result");
            StringWriter strw = new StringWriter();
            this.transformer.transform(new StreamSource(new StringReader(docXML)), new StreamResult(strw));
            String res = strw.toString();
            if (this.openIndexTagHL != null && this.openHtmlTagHL != null && this.closeIndexTagHL != null && this.closeHtmlTagHL != null) {
                res = StringUtils.replace((String)res, (String)this.openIndexTagHL, (String)this.openHtmlTagHL);
                res = StringUtils.replace((String)res, (String)this.closeIndexTagHL, (String)this.closeHtmlTagHL);
            }
            this.log.debug((Object)"end transforming row result");
            return res;
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException(e);
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setSessionParameters(HttpSession session) {
        if (session == null) {
            return;
        }
        Enumeration params = session.getAttributeNames();
        while (params.hasMoreElements()) {
            String name = params.nextElement().toString();
            this.transformer.setParameter(name, session.getAttribute(name));
        }
    }

    public void setXslt(Resource xslt) {
        this.xsltResource = xslt;
        this.log.info((Object)("got XSLT " + this.xsltResource));
    }

    public String getOpenIndexTagHL() {
        return this.openIndexTagHL;
    }

    public void setOpenIndexTagHL(String openIndexTagHL) {
        this.openIndexTagHL = openIndexTagHL;
    }

    public String getOpenHtmlTagHL() {
        return this.openHtmlTagHL;
    }

    public void setOpenHtmlTagHL(String openHtmlTagHL) {
        this.openHtmlTagHL = openHtmlTagHL;
    }

    public String getCloseIndexTagHL() {
        return this.closeIndexTagHL;
    }

    public void setCloseIndexTagHL(String closeIndexTagHL) {
        this.closeIndexTagHL = closeIndexTagHL;
    }

    public String getCloseHtmlTagHL() {
        return this.closeHtmlTagHL;
    }

    public void setCloseHtmlTagHL(String closeHtmlTagHL) {
        this.closeHtmlTagHL = closeHtmlTagHL;
    }
}

