/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.lightui.browse;

import eu.dnetlib.data.index.IIndexService;
import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.functionality.lightui.browse.BrowseCategory;
import eu.dnetlib.functionality.lightui.utils.ResultSet;
import eu.dnetlib.functionality.lightui.utils.ResultSetFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class BrowseStatsEngine {
    @Resource(name="lightuiResultSetFactory")
    protected ResultSetFactory resultSetFactory;
    protected ServiceLocator<IIndexService> indexLocator;
    private int maxElementsForCategory;
    private static final Log log = LogFactory.getLog(BrowseStatsEngine.class);

    public List<BrowseCategory> getBrowseStats(String cqlQuery, String metadataFormat, List<String> browseFields) throws IndexServiceException {
        ArrayList<BrowseCategory> list = new ArrayList<BrowseCategory>();
        String browseQuery = this.calculateBrowseQuery(cqlQuery, browseFields);
        W3CEndpointReference epr = ((IIndexService)this.indexLocator.getService()).getBrowsingStatistics(browseQuery, "all", metadataFormat, "index");
        ResultSet rs = this.resultSetFactory.newInstance(epr);
        SAXReader reader = new SAXReader();
        try {
            int tot = rs.getNumberOfElements();
            if (tot > this.maxElementsForCategory) {
                tot = this.maxElementsForCategory;
            }
            if (tot > 0) {
                for (String s : rs.getResult(1, tot)) {
                    Document doc = reader.read((Reader)new StringReader(s));
                    for (Object o : doc.selectNodes("//groupresult")) {
                        Node node = (Node)o;
                        String catName = node.valueOf("@field");
                        String valName = node.valueOf("./value");
                        int valSize = Integer.parseInt(node.valueOf("./count"));
                        boolean notFound = true;
                        for (int i = 0; i < list.size() && notFound; ++i) {
                            BrowseCategory elem = (BrowseCategory)list.get(i);
                            if (!elem.getCategoryName().equals(catName)) continue;
                            elem.insertElement(valName, valSize);
                            notFound = false;
                        }
                        if (!notFound) continue;
                        BrowseCategory elem = new BrowseCategory(catName, cqlQuery);
                        elem.insertElement(valName, valSize);
                        list.add(elem);
                    }
                }
            }
        }
        catch (ResultSetException e) {
            log.error((Object)"Error accessing resultset", (Throwable)e);
        }
        catch (DocumentException e) {
            log.error((Object)"Error parsing xml", (Throwable)e);
        }
        return list;
    }

    private String calculateBrowseQuery(String cqlQuery, List<String> browseFields) {
        String browseQuery = null;
        for (String s : browseFields) {
            if (browseQuery == null) {
                browseQuery = "query=" + cqlQuery + "&groupby=" + s;
                continue;
            }
            browseQuery = browseQuery + "," + s;
        }
        return browseQuery;
    }

    public ServiceLocator<IIndexService> getIndexLocator() {
        return this.indexLocator;
    }

    @Required
    public void setIndexLocator(ServiceLocator<IIndexService> indexLocator) {
        this.indexLocator = indexLocator;
    }

    public int getMaxElementsForCategory() {
        return this.maxElementsForCategory;
    }

    @Required
    public void setMaxElementsForCategory(int maxElementsForCategory) {
        this.maxElementsForCategory = maxElementsForCategory;
    }
}

