/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.inspector.EntryPointDescriptor;
import eu.dnetlib.enabling.inspector.EntryPointDescriptorGroup;
import eu.dnetlib.enabling.inspector.EntryPointDescriptorModel;
import eu.dnetlib.miscutils.collections.MappedCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.ModelAttribute;

public abstract class AbstractInspectorController {
    @Resource
    List<EntryPointDescriptorGroup> entryPointsGroups;

    @PostConstruct
    public void sortEntryPointGroups() {
        Collections.sort(this.entryPointsGroups, new Comparator<EntryPointDescriptorGroup>(){

            @Override
            public int compare(EntryPointDescriptorGroup o1, EntryPointDescriptorGroup o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    @ModelAttribute(value="baseUrl")
    public String baseUrl(HttpServletRequest request) {
        return request.getContextPath() + "/mvc/inspector";
    }

    @ModelAttribute(value="entryPointGroups")
    public List<EntryPointDescriptorGroup> entryPointGroups() {
        return this.entryPointsGroups;
    }

    @ModelAttribute(value="entryPoints")
    public List<EntryPointDescriptorModel> entryPoints(HttpServletRequest request) {
        final String currentRelativeUrl = request.getPathInfo().replaceAll("/inspector/(.*\\.do).*", "$1");
        ArrayList<EntryPointDescriptorModel> all = new ArrayList<EntryPointDescriptorModel>();
        UnaryFunction<EntryPointDescriptorModel, EntryPointDescriptor> mapper = new UnaryFunction<EntryPointDescriptorModel, EntryPointDescriptor>(){

            public EntryPointDescriptorModel evaluate(EntryPointDescriptor arg) {
                return new EntryPointDescriptorModel(arg.getName(), arg.getRelativeUrl(), currentRelativeUrl.equals(arg.getRelativeUrl()), arg.isHiddenAsDefault());
            }
        };
        for (EntryPointDescriptorGroup group : this.entryPointsGroups) {
            all.addAll(Lists.newArrayList((Iterable)new MappedCollection(group.getDescriptors(), (UnaryFunction)mapper)));
        }
        return all;
    }
}

