/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.solr.feed;

import com.google.common.collect.Lists;
import eu.dnetlib.functionality.index.solr.feed.InputDocumentFactory;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.solr.common.SolrInputDocument;

public class StreamingInputDocumentFactory
extends InputDocumentFactory {
    protected static final String DNETRESULT = "dnetResult";
    protected static final String TARGETFIELDS = "targetFields";
    protected static final String INDEX_RECORD_ID_ELEMENT = "indexRecordIdentifier";
    protected ThreadLocal<XMLInputFactory> inputFactory = new ThreadLocal<XMLInputFactory>(){

        @Override
        protected XMLInputFactory initialValue() {
            return XMLInputFactory.newInstance();
        }
    };
    protected ThreadLocal<XMLOutputFactory> outputFactory = new ThreadLocal<XMLOutputFactory>(){

        @Override
        protected XMLOutputFactory initialValue() {
            return XMLOutputFactory.newInstance();
        }
    };
    protected ThreadLocal<XMLEventFactory> eventFactory = new ThreadLocal<XMLEventFactory>(){

        @Override
        protected XMLEventFactory initialValue() {
            return XMLEventFactory.newInstance();
        }
    };

    @Override
    public SolrInputDocument parseDocument(String version, String inputDocument, String dsId) {
        StringWriter results = new StringWriter();
        try {
            XMLEventReader parser = this.inputFactory.get().createXMLEventReader(new StringReader(inputDocument));
            SolrInputDocument indexDocument = new SolrInputDocument();
            while (parser.hasNext()) {
                XMLEvent event = parser.nextEvent();
                if (event == null || !event.isStartElement()) continue;
                String localName = event.asStartElement().getName().getLocalPart();
                if (INDEX_RECORD_ID_ELEMENT.equals(localName)) {
                    XMLEvent text = parser.nextEvent();
                    String recordId = this.getText(text);
                    indexDocument.addField("__indexrecordidentifier", (Object)recordId);
                    continue;
                }
                if (TARGETFIELDS.equals(localName)) {
                    this.parseTargetFields(indexDocument, parser);
                    continue;
                }
                if (!DNETRESULT.equals(localName)) continue;
                this.copyResult(indexDocument, results, parser);
            }
            if (version != null) {
                indexDocument.addField("__dsversion", (Object)version);
            }
            if (dsId != null) {
                indexDocument.addField("__dsid", (Object)dsId);
            }
            if (!indexDocument.containsKey((Object)"__indexrecordidentifier")) {
                indexDocument.clear();
                System.err.println("missing indexrecord id:\n" + inputDocument);
            }
            return indexDocument;
        }
        catch (XMLStreamException e) {
            return new SolrInputDocument();
        }
    }

    protected void parseTargetFields(SolrInputDocument indexDocument, XMLEventReader parser) throws XMLStreamException {
        XMLEvent targetEvent;
        boolean hasFields = false;
        while (!(!parser.hasNext() || (targetEvent = parser.nextEvent()).isEndElement() && targetEvent.asEndElement().getName().getLocalPart().equals(TARGETFIELDS))) {
            if (!targetEvent.isStartElement()) continue;
            String fieldName = targetEvent.asStartElement().getName().getLocalPart();
            XMLEvent text = parser.nextEvent();
            String data = this.getText(text);
            this.addField(indexDocument, fieldName, data);
            hasFields = true;
        }
        if (!hasFields) {
            indexDocument.clear();
        }
    }

    protected void copyResult(SolrInputDocument indexDocument, StringWriter results, XMLEventReader parser) throws XMLStreamException {
        XMLEventWriter writer = this.outputFactory.get().createXMLEventWriter(results);
        ArrayList namespaces = Lists.newArrayList((Object[])new Namespace[]{this.eventFactory.get().createNamespace("dri", "http://www.driver-repository.eu/namespace/dri"), this.eventFactory.get().createNamespace("dr", "http://www.driver-repository.eu/namespace/dr"), this.eventFactory.get().createNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance"), this.eventFactory.get().createNamespace("dc", "http://purl.org/dc/elements/1.1/"), this.eventFactory.get().createNamespace("oaf", "http://namespace.openaire.eu/oaf")});
        StartElement newRecord = this.eventFactory.get().createStartElement("", null, "result", null, namespaces.iterator());
        writer.add(newRecord);
        while (parser.hasNext()) {
            XMLEvent resultEvent = parser.nextEvent();
            if (resultEvent.isEndElement() && resultEvent.asEndElement().getName().getLocalPart().equals(DNETRESULT)) {
                writer.add(this.eventFactory.get().createEndElement("", null, "result"));
                break;
            }
            writer.add(resultEvent);
        }
        writer.close();
        indexDocument.addField("__result", (Object)results);
    }

    private final void addField(SolrInputDocument indexDocument, String field, String value) {
        String cleaned = value.trim();
        if (!cleaned.isEmpty()) {
            indexDocument.addField(field.toLowerCase(), (Object)cleaned);
        }
    }

    protected final String getText(XMLEvent text) {
        if (text.isEndElement()) {
            return "";
        }
        return text.asCharacters().getData();
    }
}

