/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.database.objects;

import java.io.Serializable;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity(name="dnet_databases")
@Table(name="dnet_databases")
public class DnetDatabase
implements Serializable {
    private static final long serialVersionUID = 7003492091751187313L;
    private static final String PREFIX_TEMPORARY_ID = "temporary_id_";
    public static final String DATABASE_RESOURCE_TYPE = "DatabaseDSResourceType";
    @Id
    @Column(name="db_name")
    private String dbName;
    @Column(name="resource_id", unique=true)
    private String resourceId;
    @Column(name="date_creation")
    private String dateOfCreation;
    @Column(name="managed", nullable=false)
    private boolean managed = true;

    public DnetDatabase() {
    }

    public DnetDatabase(String dbName) {
        this(dbName, true);
    }

    public DnetDatabase(String dbName, Boolean managed) {
        this.dbName = dbName;
        this.resourceId = PREFIX_TEMPORARY_ID + UUID.randomUUID();
        this.dateOfCreation = "2010-01-01T00:00:00+01:00";
        if (managed != null) {
            this.managed = managed;
        }
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getDateOfCreation() {
        return this.dateOfCreation;
    }

    public void setDateOfCreation(String dateOfCreation) {
        this.dateOfCreation = dateOfCreation;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public boolean isRegistered() {
        return this.resourceId != null && !this.resourceId.isEmpty() && !this.resourceId.startsWith(PREFIX_TEMPORARY_ID);
    }
}

