/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.database.objects;

import eu.dnetlib.enabling.database.rmi.DatabaseException;
import eu.dnetlib.enabling.database.utils.DatabaseUtils;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractDAO<T>
extends HibernateDaoSupport {
    protected DatabaseUtils dbUtils;
    protected String tableName;
    private Class<T> clazz;
    private static final Log log = LogFactory.getLog(AbstractDAO.class);

    protected AbstractDAO(String tableName, Class<T> clazz) {
        this.tableName = tableName;
        this.clazz = clazz;
    }

    @Transactional(readOnly=true)
    public int count() {
        return this.getAll().size();
    }

    @Transactional(readOnly=true)
    public List<T> getAll() {
        return this.getHibernateTemplate().find("from " + this.tableName);
    }

    @Transactional
    public void delete(Serializable primaryKey) throws DatabaseException {
        log.info((Object)("Deleting " + primaryKey));
        this.delete(this.getElement(primaryKey));
    }

    public void delete(T element) throws DatabaseException {
        this.getHibernateTemplate().delete(element);
    }

    @Transactional(readOnly=true)
    public T getElement(Serializable primaryKey) {
        log.info((Object)("Loading " + this.clazz + ", key: " + primaryKey));
        return (T)this.getHibernateTemplate().get(this.clazz, primaryKey);
    }

    public void insert(T elem) throws DatabaseException {
        this.getHibernateTemplate().saveOrUpdate(elem);
    }

    @Required
    public void setDbUtils(DatabaseUtils dbUtils) {
        this.dbUtils = dbUtils;
    }
}

