/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.database.resultset;

import eu.dnetlib.enabling.database.rmi.DatabaseException;
import eu.dnetlib.enabling.database.utils.DatabaseUtils;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class SQLResultSetListener
implements ResultSetListener {
    private String db;
    private String sql;
    private DatabaseUtils dbUtils;
    private int lastToPosition = 0;
    private SqlRowSet rowSet = null;
    private Integer size = null;
    private static final Log log = LogFactory.getLog(SQLResultSetListener.class);

    protected SQLResultSetListener() {
    }

    protected SQLResultSetListener(String db, String sql, DatabaseUtils dbUtils) {
        this.db = db;
        this.sql = sql;
        this.dbUtils = dbUtils;
    }

    public List<String> getResult(int fromPosition, int toPosition) {
        if (fromPosition < 1) {
            throw new IllegalArgumentException("fromPosition must be >= 1");
        }
        if (toPosition < fromPosition) {
            throw new IllegalArgumentException("toPosition must be equal or greater than fromPosition");
        }
        int limit = toPosition - fromPosition + 1;
        try {
            ArrayList<String> list = new ArrayList<String>();
            SqlRowSet rows = this.getPage(fromPosition, toPosition);
            while (rows.next() && limit-- > 0) {
                Map<?, ?> o = this.parseRowSet(rows);
                if (!(o instanceof Map)) continue;
                list.add(this.dbUtils.rowToDocument(o).asXML());
            }
            this.lastToPosition = toPosition;
            return list;
        }
        catch (DatabaseException e) {
            log.error((Object)("Error in getResult " + fromPosition + "-" + toPosition), (Throwable)e);
            throw new IllegalStateException("Error in getResult " + fromPosition + "-" + toPosition, e);
        }
    }

    private SqlRowSet getPage(int fromPosition, int toPosition) throws DatabaseException {
        if (fromPosition == this.lastToPosition + 1 && this.rowSet != null) {
            log.debug((Object)"returning old rowset");
            this.rowSet.previous();
            return this.rowSet;
        }
        int offset = fromPosition - 1;
        String query = this.sql;
        if (offset > 0) {
            query = query + " OFFSET " + offset;
        }
        this.rowSet = this.dbUtils.executeSql(this.db, query, SqlRowSet.class);
        return this.rowSet;
    }

    private Map<?, ?> parseRowSet(SqlRowSet rows) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (String column : rows.getMetaData().getColumnNames()) {
            res.put(column, rows.getObject(column));
        }
        return res;
    }

    public int getSize() {
        if (this.size != null) {
            return this.size;
        }
        String query = "SELECT count(*) FROM ( " + this.sql + " ) AS TABLELISTENER";
        try {
            this.size = this.dbUtils.executeSql(this.db, query, Integer.class);
            return this.size;
        }
        catch (DatabaseException e) {
            log.error((Object)("Error in getSize, query: " + query), (Throwable)e);
            throw new IllegalStateException("Error in getSize, query: " + query, e);
        }
    }

    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public DatabaseUtils getDbUtils() {
        return this.dbUtils;
    }

    public void setDbUtils(DatabaseUtils dbUtils) {
        this.dbUtils = dbUtils;
    }
}

