/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.efg.mdeditor.inspector;

import com.google.common.collect.Lists;
import eu.dnetlib.efg.mdeditor.rmi.MetadataSubmitterException;
import eu.dnetlib.efg.mdeditor.rmi.MetadataSubmitterService;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class MetadataSubmitterInspector
extends AbstractInspectorController {
    @Resource
    private MetadataSubmitterService metadataSubmitterService;
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;

    @RequestMapping(value={"/inspector/mdSubmit.do"})
    public void mdSubmit(Model model, @RequestParam(value="format", required=false) String format, @RequestParam(value="record", required=false) String record) throws Exception {
        String xquery = "distinct-values(for $x in collection('/db/DRIVER/MDFormatDSResources/MDFormatDSResourceType') return $x//NAME/text())";
        List list = ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(xquery);
        model.addAttribute("formats", (Object)list);
        if (format != null && record != null) {
            model.addAttribute("format", (Object)format);
            model.addAttribute("record", (Object)record);
            try {
                this.metadataSubmitterService.submit(format, (List)Lists.newArrayList((Object[])new String[]{record}));
                model.addAttribute("message", (Object)"Record stored correcty");
            }
            catch (MetadataSubmitterException e) {
                model.addAttribute("message", (Object)("<b>ERROR: </b>" + e.getMessage()));
            }
        }
    }
}

