package eu.dnetlib.data.information.oai.publisher.sets;

import java.util.List;

import javax.annotation.Resource;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.PublisherConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;

/**
 * Collection of OAI sets defined in the publisher configuration profile.
 * 
 * @author alessia
 * 
 */
public class ConfigurationSetCollection implements SetCollection {

	@Resource
	private PublisherConfigurationReader configuration;

	@Override
	public List<SetInfo> getAllSets() {
		return this.configuration.getSets(true);
	}

	@Override
	public boolean containSet(final String set) {
		return this.configuration.getSetSpecs().contains(set);
	}

	@Override
	public String getSetQuery(final String set) {
		SetInfo setInfo = this.configuration.getSetInfo(set);
		if (setInfo == null) throw new OaiPublisherRuntimeException("No set with name " + set + " is defined in the OAI Publisher configuration profile");
		else return setInfo.getQuery();
	}

	public PublisherConfigurationReader getConfiguration() {
		return configuration;
	}

	public void setConfiguration(final PublisherConfigurationReader configuration) {
		this.configuration = configuration;
	}

}
