package eu.dnetlib.data.information.oai.publisher.wf;

import javax.annotation.Resource;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStore;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStoreDAO;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.workflow.AbstractJobNode;

/**
 * Updates one publisher store with the content from an mdstore.
 * 
 * @author alessia
 * 
 */
public class UpdatePublisherStoreJob extends AbstractJobNode {

	/**
	 * Name of the env attribute containing the mdstore identifier (the source).
	 */
	private String mdstoreIDAttributeName = "mdId";
	/**
	 * Name of the env attribute containing the publisher store identifier (the sink).
	 */
	private String pubstoreIDAttributeName = "pubstoreId";

	/**
	 * Name of the env attribute containing the publisher store identifier (the sink).
	 */
	private String repositoryIDAttributeName = "repositoryId";

	/**
	 * Publisher store DAO based on mongodb.
	 */
	@Resource
	private MongoPublisherStoreDAO publisherStoreDAO;

	/**
	 * Used to create data source descriptors from MDStore id.
	 */
	@Resource(name = "msroSourceSinkGenerator")
	private MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator;

	/**
	 * Factory for RS client.
	 */
	@Resource(name = "resultSetClientFactory")
	private ResultSetClientFactory rsClientFactory;

	/**
	 * Bean to get an endpoint reference to a mdstore data source.
	 */
	@Resource
	private DataSourceResolver dataSourceResolver;

	@Override
	public void execute(final Engine engine, final NodeToken token) {
		try {
			final String mdstoreID = token.getFullEnv().getAttribute(this.mdstoreIDAttributeName);
			final String pubstoreID = token.getFullEnv().getAttribute(this.pubstoreIDAttributeName);
			final String repoId = token.getFullEnv().getAttribute(this.repositoryIDAttributeName);
			final String dataSourceDescriptor = sourceDescriptionGenerator.generateDataSourceDescriptor(mdstoreID);

			MongoPublisherStore pubStore = this.publisherStoreDAO.getStore(pubstoreID);
			IterableResultSetClient rsClient = this.rsClientFactory.getClient(this.dataSourceResolver.resolve(dataSourceDescriptor).retrieve());

			pubStore.feed(rsClient, repoId);

		} catch (final Exception e) {
			this.failed(engine, token, e);
		}
		super.execute(engine, token);
	}

	public String getMdstoreIDAttributeName() {
		return mdstoreIDAttributeName;
	}

	public void setMdstoreIDAttributeName(String mdstoreIDAttributeName) {
		this.mdstoreIDAttributeName = mdstoreIDAttributeName;
	}

	public MongoPublisherStoreDAO getPublisherStoreDAO() {
		return publisherStoreDAO;
	}

	public void setPublisherStoreDAO(MongoPublisherStoreDAO publisherStoreDAO) {
		this.publisherStoreDAO = publisherStoreDAO;
	}

	public String getPubstoreIDAttributeName() {
		return pubstoreIDAttributeName;
	}

	public void setPubstoreIDAttributeName(String pubstoreIDAttributeName) {
		this.pubstoreIDAttributeName = pubstoreIDAttributeName;
	}

	public String getRepositoryIDAttributeName() {
		return repositoryIDAttributeName;
	}

	public void setRepositoryIDAttributeName(String repositoryIDAttributeName) {
		this.repositoryIDAttributeName = repositoryIDAttributeName;
	}

	public MDStoreDataSinkSourceDescriptorGenerator getSourceDescriptionGenerator() {
		return sourceDescriptionGenerator;
	}

	public void setSourceDescriptionGenerator(MDStoreDataSinkSourceDescriptorGenerator sourceDescriptionGenerator) {
		this.sourceDescriptionGenerator = sourceDescriptionGenerator;
	}

	public ResultSetClientFactory getRsClientFactory() {
		return rsClientFactory;
	}

	public void setRsClientFactory(ResultSetClientFactory rsClientFactory) {
		this.rsClientFactory = rsClientFactory;
	}

	public DataSourceResolver getDataSourceResolver() {
		return dataSourceResolver;
	}

	public void setDataSourceResolver(DataSourceResolver dataSourceResolver) {
		this.dataSourceResolver = dataSourceResolver;
	}
}
