package eu.dnetlib.data.information.oai.publisher.wf;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.env.Env;

import eu.dnetlib.enabling.manager.msro.AbstractWorkflowLauncherNotificationHandler;
import eu.dnetlib.enabling.tools.SplittedQueryExecutor;

public class UpdatePublisherStoreHandler extends AbstractWorkflowLauncherNotificationHandler {

	private static final Log log = LogFactory.getLog(UpdatePublisherStoreHandler.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * Name of the env attribute wheere to put the mdstore identifier.
	 */
	private String mdstoreIDAttributeName = "mdId";
	/**
	 * Name of the env attribute wheere to put the repository identifier.
	 */
	private String repositoryIDAttributeName = "repositoryId";

	/**
	 * XQuery executor.
	 */
	@Resource
	private SplittedQueryExecutor queryExecutor;

	/**
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.enabling.manager.msro.AbstractWorkflowLauncherNotificationHandler#prepareProcess(com.googlecode.sarasvati.GraphProcess,
	 *      com.googlecode.sarasvati.env.Env, java.lang.String, java.lang.String)
	 */
	@Override
	protected void prepareProcess(final GraphProcess process, final Env env, final String mdId, final String profile) {
		log.info("NotificationHandler to update pubisher store. Source mdId  = " + mdId);
		env.setAttribute(mdstoreIDAttributeName, mdId);
		String queryForRepo = "//RESOURCE_PROFILE[.//DATA_SOURCE/text() = 'dnet://MDStoreDS/" + mdId + "']//REPOSITORY_SERVICE_IDENTIFIER/text()";
		String repoId = this.queryExecutor.queryFirst(queryForRepo);
		env.setAttribute(repositoryIDAttributeName, repoId);
		log.info("Original repository  = " + repoId);
	}

	public String getMdstoreIDAttributeName() {
		return mdstoreIDAttributeName;
	}

	public void setMdstoreIDAttributeName(final String mdstoreIDAttributeName) {
		this.mdstoreIDAttributeName = mdstoreIDAttributeName;
	}

	public String getRepositoryIDAttributeName() {
		return repositoryIDAttributeName;
	}

	public void setRepositoryIDAttributeName(final String repositoryIDAttributeName) {
		this.repositoryIDAttributeName = repositoryIDAttributeName;
	}

	public SplittedQueryExecutor getQueryExecutor() {
		return queryExecutor;
	}

	public void setQueryExecutor(final SplittedQueryExecutor queryExecutor) {
		this.queryExecutor = queryExecutor;
	}
}
