package eu.dnetlib.data.information.oai.publisher.conf.sync;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationStringReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStore;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStoreDAO;

public class OAIMdFormatUpdater extends Thread {

	private static final Log log = LogFactory.getLog(OAIMdFormatUpdater.class); // NOPMD by marko on 11/24/08 5:02 PM

	private OAIConfigurationStringReader configurationReader;
	private MongoPublisherStoreDAO mongoPublisherStoreDAO;
	private OAISetCounterHelper oaiSetCounterHelper;

	@Override
	public void run() {
		List<MDFInfo> metadataFormats = this.configurationReader.getMetadataFormatInfo();
		for (MDFInfo mdfInfo : metadataFormats) {
			log.info("Checking configuration for metadata prefix " + mdfInfo.getPrefix());
			log.debug(mdfInfo);
			MongoPublisherStore store = this.mongoPublisherStoreDAO.getStoreFor(mdfInfo.getPrefix());
			if (store == null) {
				log.debug("Creating store for metadata format: \n" + mdfInfo);
				try {
					store = this.mongoPublisherStoreDAO.createStore(mdfInfo.getSourceFormatName(), mdfInfo.getSourceFormatInterpretation(),
							mdfInfo.getSourceFormatLayout());
					log.debug("Created store with id: " + store.getId());
				} catch (OaiPublisherException e) {
					log.fatal("Can't prepare store for metadata prefix " + mdfInfo.getPrefix() + ". \nCause: " + e.getMessage());
				}
			}
			log.debug("Updating counters for metadata prefix " + mdfInfo.getPrefix());
			this.oaiSetCounterHelper.updateConfiguredSetOnly(mdfInfo);
			log.info("OAI Store ready for metadata prefix " + mdfInfo.getPrefix());
		}
		log.info("All OAI stores are ready");
	}

	public OAIMdFormatUpdater(final OAIConfigurationStringReader configurationReader, final MongoPublisherStoreDAO mongoPublisherStoreDAO,
			final OAISetCounterHelper oaiSetCounterHelper) {
		super();
		this.configurationReader = configurationReader;
		this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
		this.oaiSetCounterHelper = oaiSetCounterHelper;
	}

	public OAIMdFormatUpdater() {
		super();
		// TODO Auto-generated constructor stub
	}

	public OAIConfigurationStringReader getConfigurationReader() {
		return configurationReader;
	}

	public void setConfigurationReader(final OAIConfigurationStringReader configurationReader) {
		this.configurationReader = configurationReader;
	}

	public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
		return mongoPublisherStoreDAO;
	}

	public void setMongoPublisherStoreDAO(final MongoPublisherStoreDAO mongoPublisherStoreDAO) {
		this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
	}

	public OAISetCounterHelper getOaiSetCounterHelper() {
		return oaiSetCounterHelper;
	}

	public void setOaiSetCounterHelper(final OAISetCounterHelper oaiSetCounterHelper) {
		this.oaiSetCounterHelper = oaiSetCounterHelper;
	}
}
