package eu.dnetlib.data.information.oai.publisher.conf;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;

import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.information.oai.publisher.store.PublisherField;

/**
 * An instance of this class represents an OAI Configuration profile.
 * 
 * @author alessia
 * 
 */
public class OAIConfiguration {

	/**
	 * Map for OAI sets. Keys: setSpec, values: SetInfo instances.
	 */
	private Map<String, SetInfo> setsMap;

	/**
	 * Map for metadata formats. Keys: metadata prefix, values: MDFInfo instances.
	 */
	private Map<String, MDFInfo> mdFormatsMap;

	private List<PublisherField> fields;

	private List<String> fieldNames;

	private Set<MDFInfo> sourcesMDF = Sets.newHashSet();

	public Collection<PublisherField> getFieldsFor(final String format, final String layout, final String interpretation) {
		return Collections2.filter(this.getFields(), new Predicate<PublisherField>() {

			@Override
			public boolean apply(final PublisherField theField) {
				if (theField.getSources() == null) return false;
				return theField.getSources().containsKey(StringUtils.join(new String[] { format, layout, interpretation }, "-"));
			}

		});
	}

	public Map<String, SetInfo> getSetsMap() {
		return setsMap;
	}

	public void setSetsMap(final Map<String, SetInfo> setsMap) {
		this.setsMap = setsMap;
	}

	public Map<String, MDFInfo> getMdFormatsMap() {
		return mdFormatsMap;
	}

	public void setMdFormatsMap(final Map<String, MDFInfo> mdFormatsMap) {
		this.mdFormatsMap = mdFormatsMap;
	}

	public List<PublisherField> getFields() {
		return fields;
	}

	public void setFields(final List<PublisherField> fields) {
		this.fields = fields;
	}

	public List<String> getFieldNames() {
		return fieldNames;
	}

	public void setFieldNames(final List<String> fieldNames) {
		this.fieldNames = fieldNames;
	}

	public Set<MDFInfo> getSourcesMDF() {
		return sourcesMDF;
	}

	public void setSourcesMDF(final Set<MDFInfo> sourcesMDF) {
		this.sourcesMDF = sourcesMDF;
	}

}
